/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.broadleafcommerce.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.payment.service.type.TransactionType;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.domain.CustomerImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PAYMENT_RESPONSE_ITEM")
public class PaymentResponseItemImpl
implements PaymentResponseItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentResponseItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PaymentResponseItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PaymentResponseItemImpl", allocationSize=50)
    @Column(name="PAYMENT_RESPONSE_ITEM_ID")
    protected Long id;
    @Column(name="USER_NAME", nullable=false)
    protected String userName;
    @Column(name="AMOUNT_PAID")
    protected BigDecimal amountPaid;
    @Column(name="AUTHORIZATION_CODE")
    protected String authorizationCode;
    @Column(name="MIDDLEWARE_RESPONSE_CODE")
    protected String middlewareResponseCode;
    @Column(name="MIDDLEWARE_RESPONSE_TEXT")
    protected String middlewareResponseText;
    @Column(name="PROCESSOR_RESPONSE_CODE")
    protected String processorResponseCode;
    @Column(name="PROCESSOR_RESPONSE_TEXT")
    protected String processorResponseText;
    @Column(name="IMPLEMENTOR_RESPONSE_CODE")
    protected String implementorResponseCode;
    @Column(name="IMPLEMENTOR_RESPONSE_TEXT")
    protected String implementorResponseText;
    @Column(name="REFERENCE_NUMBER")
    protected String referenceNumber;
    @Column(name="TRANSACTION_SUCCESS")
    protected Boolean transactionSuccess;
    @Column(name="TRANSACTION_TIMESTAMP", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date transactionTimestamp;
    @Column(name="TRANSACTION_ID")
    protected String transactionId;
    @Column(name="AVS_CODE")
    protected String avsCode;
    @Transient
    protected String cvvCode;
    @Column(name="REMAINING_BALANCE")
    protected BigDecimal remainingBalance;
    @Column(name="TRANSACTION_TYPE", nullable=false)
    protected String transactionType;
    @CollectionOfElements
    @JoinTable(name="BLC_PAYMENT_ADDITIONAL_FIELDS", joinColumns={@JoinColumn(name="PAYMENT_RESPONSE_ITEM_ID")})
    @MapKey(columns={@Column(name="FIELD_NAME", length=150)})
    @Column(name="FIELD_VALUE")
    protected Map<String, String> additionalFields = new HashMap<String, String>();
    @Column(name="ORDER_PAYMENT_ID")
    protected Long paymentInfoId;
    @ManyToOne(targetEntity=CustomerImpl.class)
    @JoinColumn(name="CUSTOMER_ID")
    protected Customer customer;
    @Column(name="PAYMENT_INFO_REFERENCE_NUMBER")
    protected String paymentInfoReferenceNumber;

    @Override
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Override
    public String getMiddlewareResponseCode() {
        return this.middlewareResponseCode;
    }

    @Override
    public void setMiddlewareResponseCode(String middlewareResponseCode) {
        this.middlewareResponseCode = middlewareResponseCode;
    }

    @Override
    public String getMiddlewareResponseText() {
        return this.middlewareResponseText;
    }

    @Override
    public void setMiddlewareResponseText(String middlewareResponseText) {
        this.middlewareResponseText = middlewareResponseText;
    }

    @Override
    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    @Override
    public void setProcessorResponseCode(String processorResponseCode) {
        this.processorResponseCode = processorResponseCode;
    }

    @Override
    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    @Override
    public void setProcessorResponseText(String processorResponseText) {
        this.processorResponseText = processorResponseText;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public Money getAmountPaid() {
        return this.amountPaid == null ? null : new Money(this.amountPaid);
    }

    @Override
    public void setAmountPaid(Money amountPaid) {
        this.amountPaid = Money.toAmount((Money)amountPaid);
    }

    @Override
    public Boolean getTransactionSuccess() {
        return this.transactionSuccess;
    }

    @Override
    public void setTransactionSuccess(Boolean transactionSuccess) {
        this.transactionSuccess = transactionSuccess;
    }

    @Override
    public Date getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    @Override
    public void setTransactionTimestamp(Date transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    @Override
    public String getImplementorResponseCode() {
        return this.implementorResponseCode;
    }

    @Override
    public void setImplementorResponseCode(String implementorResponseCode) {
        this.implementorResponseCode = implementorResponseCode;
    }

    @Override
    public String getImplementorResponseText() {
        return this.implementorResponseText;
    }

    @Override
    public void setImplementorResponseText(String implementorResponseText) {
        this.implementorResponseText = implementorResponseText;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String getAvsCode() {
        return this.avsCode;
    }

    @Override
    public void setAvsCode(String avsCode) {
        this.avsCode = avsCode;
    }

    @Override
    public String getCvvCode() {
        return this.cvvCode;
    }

    @Override
    public void setCvvCode(String cvvCode) {
        this.cvvCode = cvvCode;
    }

    @Override
    public Money getRemainingBalance() {
        return this.remainingBalance == null ? null : new Money(this.remainingBalance);
    }

    @Override
    public void setRemainingBalance(Money remainingBalance) {
        this.remainingBalance = Money.toAmount((Money)remainingBalance);
    }

    @Override
    public TransactionType getTransactionType() {
        return this.transactionType == null ? null : TransactionType.getInstance(this.transactionType);
    }

    @Override
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType.getType();
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getPaymentInfoId() {
        return this.paymentInfoId;
    }

    @Override
    public void setPaymentInfoId(Long paymentInfoId) {
        this.paymentInfoId = paymentInfoId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public String getPaymentInfoReferenceNumber() {
        return this.paymentInfoReferenceNumber;
    }

    @Override
    public void setPaymentInfoReferenceNumber(String paymentInfoReferenceNumber) {
        this.paymentInfoReferenceNumber = paymentInfoReferenceNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(PaymentResponseItem.class.getName() + "\n");
        sb.append("auth code: " + this.getAuthorizationCode() + "\n");
        sb.append("implementor response code: " + this.getImplementorResponseCode() + "\n");
        sb.append("implementor response text: " + this.getImplementorResponseText() + "\n");
        sb.append("middleware response code: " + this.getMiddlewareResponseCode() + "\n");
        sb.append("middleware response text: " + this.getMiddlewareResponseText() + "\n");
        sb.append("processor response code: " + this.getProcessorResponseCode() + "\n");
        sb.append("processor response text: " + this.getProcessorResponseText() + "\n");
        sb.append("reference number: " + this.getReferenceNumber() + "\n");
        sb.append("transaction id: " + this.getTransactionId() + "\n");
        sb.append("avs code: " + this.getAvsCode() + "\n");
        if (this.remainingBalance != null) {
            sb.append("remaining balance: " + this.getRemainingBalance());
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentResponseItemImpl other = (PaymentResponseItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.transactionId == null ? other.transactionId != null : !this.transactionId.equals(other.transactionId));
    }
}

