/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.encryption.EncryptionModule;
import org.broadleafcommerce.payment.domain.BankAccountPaymentInfo;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BANK_ACCOUNT_PAYMENT")
public class BankAccountPaymentInfoImpl
implements BankAccountPaymentInfo {
    private static final long serialVersionUID = 1L;
    @Transient
    protected EncryptionModule encryptionModule;
    @Id
    @GeneratedValue(generator="BankPaymentId", strategy=GenerationType.TABLE)
    @TableGenerator(name="BankPaymentId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="BankAccountPaymentInfoImpl", allocationSize=50)
    @Column(name="PAYMENT_ID")
    protected Long id;
    @Column(name="REFERENCE_NUMBER", nullable=false)
    protected String referenceNumber;
    @Column(name="ACCOUNT_NUMBER", nullable=false)
    protected String accountNumber;
    @Column(name="ROUTING_NUMBER", nullable=false)
    protected String routingNumber;

    protected BankAccountPaymentInfoImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public String getAccountNumber() {
        return this.encryptionModule.decrypt(this.accountNumber);
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = this.encryptionModule.encrypt(accountNumber);
    }

    @Override
    public String getRoutingNumber() {
        return this.encryptionModule.decrypt(this.routingNumber);
    }

    @Override
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = this.encryptionModule.encrypt(routingNumber);
    }

    @Override
    public EncryptionModule getEncryptionModule() {
        return this.encryptionModule;
    }

    @Override
    public void setEncryptionModule(EncryptionModule encryptionModule) {
        this.encryptionModule = encryptionModule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountNumber == null ? 0 : this.accountNumber.hashCode());
        result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
        result = 31 * result + (this.routingNumber == null ? 0 : this.routingNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BankAccountPaymentInfoImpl other = (BankAccountPaymentInfoImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.accountNumber == null ? other.accountNumber != null : !this.accountNumber.equals(other.accountNumber)) {
            return false;
        }
        if (this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber)) {
            return false;
        }
        return !(this.routingNumber == null ? other.routingNumber != null : !this.routingNumber.equals(other.routingNumber));
    }
}

