/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.service.type;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class OrderItemType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OrderItemType> types = new Hashtable<String, OrderItemType>();
    public static OrderItemType DISCRETE = new OrderItemType("org.broadleafcommerce.order.domain.DiscreteOrderItem");
    public static OrderItemType BUNDLE = new OrderItemType("org.broadleafcommerce.order.domain.BundleOrderItem");
    public static OrderItemType GIFTWRAP = new OrderItemType("org.broadleafcommerce.order.domain.GiftWrapOrderItem");
    private String type;

    public static OrderItemType getInstance(String type) {
        return types.get(type);
    }

    public OrderItemType() {
    }

    public OrderItemType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!types.containsKey(type)) {
            types.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemType other = (OrderItemType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

