/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.catalog.dao.CategoryDao;
import org.broadleafcommerce.catalog.dao.ProductDao;
import org.broadleafcommerce.catalog.dao.SkuDao;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.offer.dao.OfferDao;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.order.dao.OrderDao;
import org.broadleafcommerce.order.domain.BundleOrderItem;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.PersonalMessage;
import org.broadleafcommerce.order.service.FulfillmentGroupService;
import org.broadleafcommerce.order.service.OrderItemService;
import org.broadleafcommerce.order.service.OrderService;
import org.broadleafcommerce.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.order.service.call.OrderItemRequest;
import org.broadleafcommerce.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.order.service.type.OrderStatus;
import org.broadleafcommerce.payment.dao.PaymentInfoDao;
import org.broadleafcommerce.payment.domain.PaymentInfo;
import org.broadleafcommerce.payment.domain.Referenced;
import org.broadleafcommerce.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.pricing.service.advice.PricingExecutionManager;
import org.broadleafcommerce.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.domain.Address;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.workflow.WorkflowException;

public class OrderServiceImpl
implements OrderService {
    private static final Log LOG = LogFactory.getLog(OrderServiceImpl.class);
    @Resource(name="blOrderDao")
    protected OrderDao orderDao;
    @Resource(name="blPaymentInfoDao")
    protected PaymentInfoDao paymentInfoDao;
    @Resource(name="blFulfillmentGroupDao")
    protected FulfillmentGroupDao fulfillmentGroupDao;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blPricingExecutionManager")
    protected PricingExecutionManager pricingExecutionManager;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;
    protected boolean rollupOrderItems = true;

    @Override
    public Order createNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.orderDao.create();
        namedOrder.setCustomer(customer);
        namedOrder.setName(name);
        namedOrder.setStatus(OrderStatus.NAMED);
        return this.persistOrder(namedOrder);
    }

    @Override
    public Order save(Order order, boolean priceOrder) throws PricingException {
        return this.updateOrder(order, priceOrder);
    }

    @Override
    public Order findOrderById(Long orderId) {
        return this.orderDao.readOrderById(orderId);
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer) {
        return this.orderDao.readOrdersForCustomer(customer.getId());
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer, OrderStatus status) {
        return this.orderDao.readOrdersForCustomer(customer, status);
    }

    @Override
    public Order findNamedOrderForCustomer(String name, Customer customer) {
        return this.orderDao.readNamedOrderForCustomer(customer, name);
    }

    @Override
    public FulfillmentGroup findDefaultFulfillmentGroupForOrder(Order order) {
        FulfillmentGroup fg = this.fulfillmentGroupDao.readDefaultFulfillmentGroupForOrder(order);
        return fg;
    }

    @Override
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity, boolean priceOrder) throws PricingException {
        if (orderId == null || skuId == null || quantity == null) {
            return null;
        }
        Order order = this.findOrderById(orderId);
        Sku sku = this.skuDao.readSkuById(skuId);
        Product product = productId != null ? this.productDao.readProductById(productId) : null;
        Category category = categoryId != null ? this.categoryDao.readCategoryById(categoryId) : null;
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setProduct(product);
        itemRequest.setQuantity(quantity);
        itemRequest.setSku(sku);
        return this.addDiscreteItemToOrder(order, itemRequest, priceOrder);
    }

    @Override
    public OrderItem addDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        DiscreteOrderItem item = this.orderItemService.createDiscreteOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public OrderItem addGiftWrapItemToOrder(Order order, GiftWrapOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        GiftWrapOrderItem item = this.orderItemService.createGiftWrapOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public OrderItem addBundleItemToOrder(Order order, BundleOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        BundleOrderItem item = this.orderItemService.createBundleOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public List<OrderItem> addItemsToOrder(Order order, List<OrderItemRequest> orderItemRequests, boolean priceOrder) throws PricingException {
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        for (OrderItemRequest orderItemRequest : orderItemRequests) {
            if (orderItemRequest instanceof DiscreteOrderItemRequest) {
                orderItems.add(this.orderItemService.createDiscreteOrderItem((DiscreteOrderItemRequest)orderItemRequest));
                continue;
            }
            if (orderItemRequest instanceof BundleOrderItemRequest) {
                orderItems.add(this.orderItemService.createBundleOrderItem((BundleOrderItemRequest)orderItemRequest));
                continue;
            }
            if (!(orderItemRequest instanceof GiftWrapOrderItemRequest)) continue;
            orderItems.add(this.orderItemService.createGiftWrapOrderItem((GiftWrapOrderItemRequest)orderItemRequest));
        }
        List<OrderItem> addedItems = this.addOrderItemsToOrder(order, orderItems, priceOrder);
        return addedItems;
    }

    @Override
    public Order removeItemFromOrder(Long orderId, Long itemId, boolean priceOrder) throws PricingException {
        Order order = this.findOrderById(orderId);
        OrderItem orderItem = this.orderItemService.readOrderItemById(itemId);
        return this.removeItemFromOrder(order, orderItem, priceOrder);
    }

    @Override
    public Order removeItemFromOrder(Order order, OrderItem item, boolean priceOrder) throws PricingException {
        this.removeOrderItemFromFullfillmentGroup(order, item);
        OrderItem itemFromOrder = order.getOrderItems().remove(order.getOrderItems().indexOf(item));
        this.orderItemService.delete(itemFromOrder);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public Order removeItemsFromOrder(Order order, List<OrderItem> items, boolean priceOrder) throws PricingException {
        for (OrderItem item : items) {
            OrderItem itemFromOrder = order.getOrderItems().remove(order.getOrderItems().indexOf(item));
            this.orderItemService.delete(itemFromOrder);
            this.removeOrderItemFromFullfillmentGroup(order, item);
        }
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    public Order removeItemFromOrder(Order order, List<OrderItem> items, boolean priceOrder) throws PricingException {
        for (OrderItem item : items) {
            OrderItem itemFromOrder = order.getOrderItems().remove(order.getOrderItems().indexOf(item));
            this.orderItemService.delete(itemFromOrder);
            this.removeOrderItemFromFullfillmentGroup(order, item);
        }
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public PaymentInfo addPaymentToOrder(Order order, PaymentInfo payment) {
        return this.addPaymentToOrder(order, payment, null);
    }

    @Override
    public PaymentInfo addPaymentToOrder(Order order, PaymentInfo payment, Referenced securePaymentInfo) {
        payment.setOrder(order);
        order.getPaymentInfos().add(payment);
        order = this.persistOrder(order);
        int paymentIndex = order.getPaymentInfos().size() - 1;
        if (securePaymentInfo != null) {
            this.securePaymentInfoService.save(securePaymentInfo);
        }
        return order.getPaymentInfos().get(paymentIndex);
    }

    @Override
    public void removeAllPaymentsFromOrder(Order order) {
        this.removePaymentsFromOrder(order, null);
    }

    @Override
    public void removePaymentsFromOrder(Order order, PaymentInfoType paymentInfoType) {
        ArrayList<PaymentInfo> infos = new ArrayList<PaymentInfo>();
        for (PaymentInfo paymentInfo : order.getPaymentInfos()) {
            if (paymentInfoType != null && !paymentInfoType.equals(paymentInfo.getType())) continue;
            infos.add(paymentInfo);
        }
        order.getPaymentInfos().removeAll(infos);
        for (PaymentInfo paymentInfo : infos) {
            try {
                this.securePaymentInfoService.findAndRemoveSecurePaymentInfo(paymentInfo.getReferenceNumber(), paymentInfo.getType());
            }
            catch (WorkflowException e) {
                LOG.debug((Object)"No secure payment is associated with the PaymentInfo", (Throwable)e);
            }
            order.getPaymentInfos().remove(paymentInfo);
            paymentInfo = this.paymentInfoDao.readPaymentInfoById(paymentInfo.getId());
            this.paymentInfoDao.delete(paymentInfo);
        }
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest, boolean priceOrder) throws PricingException {
        FulfillmentGroup fg = this.fulfillmentGroupDao.create();
        fg.setAddress(fulfillmentGroupRequest.getAddress());
        fg.setOrder(fulfillmentGroupRequest.getOrder());
        fg.setPhone(fulfillmentGroupRequest.getPhone());
        fg.setMethod(fulfillmentGroupRequest.getMethod());
        for (FulfillmentGroupItemRequest request : fulfillmentGroupRequest.getFulfillmentGroupItemRequests()) {
            fg = this.addItemToFulfillmentGroup(request.getOrderItem(), fg, request.getQuantity(), false);
        }
        this.updateOrder(fg.getOrder(), priceOrder);
        return fg;
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        FulfillmentGroup dfg = this.findDefaultFulfillmentGroupForOrder(order);
        if (dfg == null) {
            fulfillmentGroup.setPrimary(true);
        } else if (dfg.equals(fulfillmentGroup)) {
            fulfillmentGroup.setPrimary(true);
            order.getFulfillmentGroups().remove(dfg);
        }
        fulfillmentGroup.setOrder(order);
        for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                if (fg.equals(fulfillmentGroup)) continue;
                fg.getFulfillmentGroupItems().remove(fgItem);
            }
        }
        fulfillmentGroup = this.fulfillmentGroupDao.save(fulfillmentGroup);
        order.getFulfillmentGroups().add(fulfillmentGroup);
        int fulfillmentGroupIndex = order.getFulfillmentGroups().size() - 1;
        order = this.updateOrder(order, priceOrder);
        return order.getFulfillmentGroups().get(fulfillmentGroupIndex);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity, boolean priceOrder) throws PricingException {
        Order order = item.getOrder();
        if (fulfillmentGroup.getId() == null) {
            fulfillmentGroup = this.addFulfillmentGroupToOrder(order, fulfillmentGroup, priceOrder);
        }
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            Iterator<FulfillmentGroupItem> itr = fg.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fgItem = itr.next();
                if (!fgItem.getOrderItem().equals(item)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fgItem);
            }
        }
        FulfillmentGroupItem fgi = this.createFulfillmentGroupItemFromOrderItem(item, fulfillmentGroup, quantity);
        fgi = this.fulfillmentGroupItemDao.save(fgi);
        fulfillmentGroup.addFulfillmentGroupItem(fgi);
        order = this.updateOrder(order, priceOrder);
        fulfillmentGroup.setOrder(order);
        return fulfillmentGroup;
    }

    @Override
    public FulfillmentGroup addItemsToFulfillmentGroup(List<OrderItem> items, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        Order order = null;
        if (fulfillmentGroup.getId() == null && items != null && !items.isEmpty()) {
            order = items.get(0).getOrder();
            fulfillmentGroup = this.addFulfillmentGroupToOrder(order, fulfillmentGroup, false);
        } else {
            order = fulfillmentGroup.getOrder();
        }
        for (OrderItem item : items) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                Iterator<FulfillmentGroupItem> itr = fg.getFulfillmentGroupItems().iterator();
                while (itr.hasNext()) {
                    FulfillmentGroupItem fgItem = itr.next();
                    if (!fgItem.getOrderItem().equals(item)) continue;
                    itr.remove();
                    this.fulfillmentGroupItemDao.delete(fgItem);
                }
            }
            FulfillmentGroupItem fgi = this.createFulfillmentGroupItemFromOrderItem(item, fulfillmentGroup, item.getQuantity());
            fgi = this.fulfillmentGroupItemDao.save(fgi);
            fulfillmentGroup.addFulfillmentGroupItem(fgi);
        }
        order = this.updateOrder(order, priceOrder);
        return fulfillmentGroup;
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, item.getQuantity(), true);
    }

    @Override
    public Order addOfferToOrder(Order order, String offerCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateItemQuantity(Order order, OrderItem item, boolean priceOrder) throws ItemNotFoundException, PricingException {
        if (!order.getOrderItems().contains(item)) {
            throw new ItemNotFoundException("Order Item (" + item.getId() + ") not found in Order (" + order.getId() + ")");
        }
        OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(item));
        itemFromOrder.setQuantity(item.getQuantity());
        order = this.updateOrder(order, priceOrder);
    }

    @Override
    public void removeAllFulfillmentGroupsFromOrder(Order order, boolean priceOrder) throws PricingException {
        if (order.getFulfillmentGroups() != null) {
            Iterator<FulfillmentGroup> iterator = order.getFulfillmentGroups().iterator();
            while (iterator.hasNext()) {
                FulfillmentGroup fulfillmentGroup = iterator.next();
                iterator.remove();
                this.fulfillmentGroupDao.delete(fulfillmentGroup);
            }
            this.updateOrder(order, priceOrder);
        }
    }

    @Override
    public void removeFulfillmentGroupFromOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        order.getFulfillmentGroups().remove(fulfillmentGroup);
        this.fulfillmentGroupDao.delete(fulfillmentGroup);
        this.updateOrder(order, priceOrder);
    }

    @Override
    public Order removeOfferFromOrder(Order order, Offer offer, boolean priceOrder) throws PricingException {
        order.getCandidateOrderOffers().remove(offer);
        this.offerDao.delete(offer);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public Order removeAllOffersFromOrder(Order order, boolean priceOrder) throws PricingException {
        order.getCandidateOrderOffers().clear();
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public void removeNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.findNamedOrderForCustomer(name, customer);
        this.cancelOrder(namedOrder);
    }

    @Override
    public Order confirmOrder(Order order) {
        return this.orderDao.submitOrder(order);
    }

    @Override
    public void cancelOrder(Order order) {
        this.orderDao.delete(order);
    }

    @Override
    public List<PaymentInfo> readPaymentInfosForOrder(Order order) {
        return this.paymentInfoDao.readPaymentInfosForOrder(order);
    }

    @Override
    public OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem, boolean priceOrder) throws PricingException {
        int orderItemIndex;
        List<OrderItem> orderItems = order.getOrderItems();
        boolean containsItem = orderItems.contains(newOrderItem);
        if (this.rollupOrderItems && containsItem) {
            OrderItem itemFromOrder = orderItems.get(orderItems.indexOf(newOrderItem));
            itemFromOrder.setQuantity(itemFromOrder.getQuantity() + newOrderItem.getQuantity());
            orderItemIndex = orderItems.indexOf(itemFromOrder);
        } else {
            orderItems.add(newOrderItem);
            newOrderItem.setOrder(order);
            orderItemIndex = orderItems.size() - 1;
        }
        order = this.updateOrder(order, priceOrder);
        return order.getOrderItems().get(orderItemIndex);
    }

    @Override
    public List<OrderItem> addOrderItemsToOrder(Order order, List<OrderItem> newOrderItems, boolean priceOrder) throws PricingException {
        ArrayList<Integer> orderItemIndexes = new ArrayList<Integer>();
        List<OrderItem> orderItems = order.getOrderItems();
        for (OrderItem newOrderItem : newOrderItems) {
            boolean containsItem = orderItems.contains(newOrderItem);
            if (this.rollupOrderItems && containsItem) {
                OrderItem itemFromOrder = orderItems.get(orderItems.indexOf(newOrderItem));
                itemFromOrder.setQuantity(itemFromOrder.getQuantity() + newOrderItem.getQuantity());
                orderItemIndexes.add(orderItems.indexOf(itemFromOrder));
                continue;
            }
            orderItems.add(newOrderItem);
            newOrderItem.setOrder(order);
            orderItemIndexes.add(orderItems.size() - 1);
        }
        order = this.updateOrder(order, priceOrder);
        ArrayList<OrderItem> returnedOrderItems = new ArrayList<OrderItem>();
        for (Integer orderItemIndex : orderItemIndexes) {
            returnedOrderItems.add(order.getOrderItems().get(orderItemIndex));
        }
        return returnedOrderItems;
    }

    @Override
    public FulfillmentGroup createDefaultFulfillmentGroup(Order order, Address address) {
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (!fulfillmentGroup.isPrimary()) continue;
            return fulfillmentGroup;
        }
        FulfillmentGroup newFg = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
        newFg.setOrder(order);
        newFg.setPrimary(true);
        newFg.setAddress(address);
        for (OrderItem orderItem : order.getOrderItems()) {
            newFg.addFulfillmentGroupItem(this.createFulfillmentGroupItemFromOrderItem(orderItem, newFg, orderItem.getQuantity()));
        }
        return newFg;
    }

    public boolean isRollupOrderItems() {
        return this.rollupOrderItems;
    }

    public void setRollupOrderItems(boolean rollupOrderItems) {
        this.rollupOrderItems = rollupOrderItems;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public PaymentInfoDao getPaymentInfoDao() {
        return this.paymentInfoDao;
    }

    public void setPaymentInfoDao(PaymentInfoDao paymentInfoDao) {
        this.paymentInfoDao = paymentInfoDao;
    }

    public FulfillmentGroupDao getFulfillmentGroupDao() {
        return this.fulfillmentGroupDao;
    }

    public void setFulfillmentGroupDao(FulfillmentGroupDao fulfillmentGroupDao) {
        this.fulfillmentGroupDao = fulfillmentGroupDao;
    }

    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    public PricingExecutionManager getPricingExecutionManager() {
        return this.pricingExecutionManager;
    }

    public void setPricingExecutionManager(PricingExecutionManager pricingExecutionManager) {
        this.pricingExecutionManager = pricingExecutionManager;
    }

    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public Order findOrderByOrderNumber(String orderNumber) {
        return this.orderDao.readOrderByOrderNumber(orderNumber);
    }

    protected Order updateOrder(Order order, Boolean priceOrder) throws PricingException {
        if (priceOrder.booleanValue()) {
            this.pricingExecutionManager.executePricing(order);
        } else {
            order = this.persistOrder(order);
        }
        return order;
    }

    protected Order persistOrder(Order order) {
        return this.orderDao.save(order);
    }

    protected FulfillmentGroupItem createFulfillmentGroupItemFromOrderItem(OrderItem orderItem, FulfillmentGroup fulfillmentGroup, int quantity) {
        FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.create();
        fgi.setFulfillmentGroup(fulfillmentGroup);
        fgi.setOrderItem(orderItem);
        fgi.setQuantity(quantity);
        fgi.setPrice(orderItem.getPrice());
        fgi.setRetailPrice(orderItem.getRetailPrice());
        fgi.setSalePrice(orderItem.getSalePrice());
        return fgi;
    }

    protected void removeOrderItemFromFullfillmentGroup(Order order, OrderItem orderItem) {
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            Iterator<FulfillmentGroupItem> itr = fulfillmentGroup.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fulfillmentGroupItem = itr.next();
                if (!fulfillmentGroupItem.getOrderItem().equals(orderItem)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
            }
        }
    }

    protected DiscreteOrderItemRequest createDiscreteOrderItemRequest(DiscreteOrderItem discreteOrderItem) {
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setCategory(discreteOrderItem.getCategory());
        itemRequest.setProduct(discreteOrderItem.getProduct());
        itemRequest.setQuantity(discreteOrderItem.getQuantity());
        itemRequest.setSku(discreteOrderItem.getSku());
        if (discreteOrderItem.getPersonalMessage() != null) {
            PersonalMessage personalMessage = this.orderItemService.createPersonalMessage();
            try {
                BeanUtils.copyProperties((Object)personalMessage, (Object)discreteOrderItem.getPersonalMessage());
                personalMessage.setId(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            itemRequest.setPersonalMessage(personalMessage);
        }
        return itemRequest;
    }

    protected BundleOrderItemRequest createBundleOrderItemRequest(BundleOrderItem bundleOrderItem, List<DiscreteOrderItemRequest> discreteOrderItemRequests) {
        BundleOrderItemRequest bundleOrderItemRequest = new BundleOrderItemRequest();
        bundleOrderItemRequest.setCategory(bundleOrderItem.getCategory());
        bundleOrderItemRequest.setName(bundleOrderItem.getName());
        bundleOrderItemRequest.setQuantity(bundleOrderItem.getQuantity());
        bundleOrderItemRequest.setDiscreteOrderItems(discreteOrderItemRequests);
        return bundleOrderItemRequest;
    }
}

