/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.service;

import javax.annotation.Resource;
import org.broadleafcommerce.order.dao.OrderItemDao;
import org.broadleafcommerce.order.domain.BundleOrderItem;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.PersonalMessage;
import org.broadleafcommerce.order.service.OrderItemService;
import org.broadleafcommerce.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.order.service.call.OrderItemRequest;
import org.broadleafcommerce.order.service.type.OrderItemType;
import org.springframework.stereotype.Service;

@Service(value="blOrderItemService")
public class OrderItemServiceImpl
implements OrderItemService {
    @Resource(name="blOrderItemDao")
    protected OrderItemDao orderItemDao;

    @Override
    public OrderItem readOrderItemById(Long orderItemId) {
        return this.orderItemDao.readOrderItemById(orderItemId);
    }

    @Override
    public OrderItem saveOrderItem(OrderItem orderItem) {
        return this.orderItemDao.saveOrderItem(orderItem);
    }

    @Override
    public OrderItem createOrderItem(OrderItemRequest itemRequest) {
        OrderItem orderItem = null;
        if (itemRequest instanceof DiscreteOrderItem) {
            orderItem = this.createDiscreteOrderItem((DiscreteOrderItemRequest)itemRequest);
        } else if (itemRequest instanceof GiftWrapOrderItem) {
            orderItem = this.createGiftWrapOrderItem((GiftWrapOrderItemRequest)itemRequest);
        } else if (itemRequest instanceof BundleOrderItemRequest) {
            orderItem = this.createBundleOrderItem((BundleOrderItemRequest)itemRequest);
        }
        return orderItem;
    }

    @Override
    public DiscreteOrderItem createDiscreteOrderItem(DiscreteOrderItemRequest itemRequest) {
        DiscreteOrderItem item = (DiscreteOrderItem)this.orderItemDao.create(OrderItemType.DISCRETE);
        item.setSku(itemRequest.getSku());
        item.setQuantity(itemRequest.getQuantity());
        item.setCategory(itemRequest.getCategory());
        item.setProduct(itemRequest.getProduct());
        item.setSalePrice(itemRequest.getSku().getSalePrice());
        item.setRetailPrice(itemRequest.getSku().getRetailPrice());
        item.assignFinalPrice();
        item.setPersonalMessage(itemRequest.getPersonalMessage());
        return item;
    }

    @Override
    public GiftWrapOrderItem createGiftWrapOrderItem(GiftWrapOrderItemRequest itemRequest) {
        GiftWrapOrderItem item = (GiftWrapOrderItem)this.orderItemDao.create(OrderItemType.GIFTWRAP);
        item.setSku(itemRequest.getSku());
        item.setQuantity(itemRequest.getQuantity());
        item.setCategory(itemRequest.getCategory());
        item.setProduct(itemRequest.getProduct());
        item.setSalePrice(itemRequest.getSku().getSalePrice());
        item.setRetailPrice(itemRequest.getSku().getRetailPrice());
        item.assignFinalPrice();
        item.getWrappedItems().addAll(itemRequest.getWrappedItems());
        for (OrderItem orderItem : item.getWrappedItems()) {
            orderItem.setGiftWrapOrderItem(item);
        }
        return item;
    }

    @Override
    public BundleOrderItem createBundleOrderItem(BundleOrderItemRequest itemRequest) {
        BundleOrderItem item = (BundleOrderItem)this.orderItemDao.create(OrderItemType.BUNDLE);
        item.setQuantity(itemRequest.getQuantity());
        item.setCategory(itemRequest.getCategory());
        item.setName(itemRequest.getName());
        for (DiscreteOrderItemRequest discreteItemRequest : itemRequest.getDiscreteOrderItems()) {
            DiscreteOrderItem discreteOrderItem = this.createDiscreteOrderItem(discreteItemRequest);
            discreteOrderItem.setBundleOrderItem(item);
            item.getDiscreteOrderItems().add(discreteOrderItem);
            item.assignFinalPrice();
        }
        return item;
    }

    @Override
    public void delete(OrderItem item) {
        this.orderItemDao.delete(item);
    }

    @Override
    public PersonalMessage createPersonalMessage() {
        return this.orderItemDao.createPersonalMessage();
    }
}

