/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.CategoryImpl;
import org.broadleafcommerce.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.order.domain.GiftWrapOrderItemImpl;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderImpl;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.PersonalMessage;
import org.broadleafcommerce.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.order.service.type.OrderItemType;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class OrderItemImpl
implements OrderItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OrderItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="OrderItemImpl", allocationSize=50)
    @Column(name="ORDER_ITEM_ID")
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="CATEGORY_ID")
    @NotFound(action=NotFoundAction.IGNORE)
    protected Category category;
    @ManyToOne(targetEntity=OrderImpl.class)
    @JoinColumn(name="ORDER_ID")
    protected Order order;
    @Column(name="RETAIL_PRICE")
    protected BigDecimal retailPrice;
    @Column(name="SALE_PRICE")
    protected BigDecimal salePrice;
    @Column(name="PRICE")
    protected BigDecimal price;
    @Column(name="QUANTITY", nullable=false)
    protected int quantity;
    @Transient
    protected BigDecimal adjustmentPrice;
    @ManyToOne(targetEntity=PersonalMessageImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected PersonalMessage personalMessage;
    @ManyToOne(targetEntity=GiftWrapOrderItemImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="GIFT_WRAP_ITEM_ID", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected GiftWrapOrderItem giftWrapOrderItem;
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItemAdjustment> orderItemAdjustments = new ArrayList<OrderItemAdjustment>();
    @OneToMany(mappedBy="orderItem", targetEntity=CandidateItemOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateItemOffer> candidateItemOffers = new ArrayList<CandidateItemOffer>();
    @Transient
    protected int markedForOffer = 0;
    @Transient
    protected boolean notCombinableOfferApplied = false;
    @Transient
    protected boolean hasOrderItemAdjustments = false;
    @Column(name="ORDER_ITEM_TYPE")
    protected String orderItemType;

    @Override
    public Money getRetailPrice() {
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getSalePrice() {
        return this.salePrice == null ? null : new Money(this.salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getPrice() {
        return this.price == null ? null : new Money(this.price);
    }

    @Override
    public void setPrice(Money finalPrice) {
        this.price = Money.toAmount((Money)finalPrice);
    }

    @Override
    public void assignFinalPrice() {
        this.price = this.getCurrentPrice().getAmount();
    }

    @Override
    public Money getTaxablePrice() {
        return this.getPrice();
    }

    @Override
    public Money getCurrentPrice() {
        this.updatePrices();
        Money currentPrice = null;
        currentPrice = this.adjustmentPrice != null ? new Money(this.adjustmentPrice) : (this.salePrice != null ? new Money(this.salePrice) : new Money(this.retailPrice));
        return currentPrice;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public List<CandidateItemOffer> getCandidateItemOffers() {
        return this.candidateItemOffers;
    }

    @Override
    public void setCandidateItemOffers(List<CandidateItemOffer> candidateItemOffers) {
        this.candidateItemOffers = candidateItemOffers;
    }

    @Override
    public void addCandidateItemOffer(CandidateItemOffer candidateItemOffer) {
        this.candidateItemOffers.add(candidateItemOffer);
    }

    @Override
    public void removeAllCandidateItemOffers() {
        if (this.candidateItemOffers != null) {
            this.candidateItemOffers.clear();
        }
    }

    @Override
    public boolean markForOffer() {
        if (this.markedForOffer >= this.quantity) {
            return false;
        }
        ++this.markedForOffer;
        return true;
    }

    @Override
    public int getMarkedForOffer() {
        return this.markedForOffer;
    }

    @Override
    public boolean unmarkForOffer() {
        if (this.markedForOffer < 1) {
            return false;
        }
        --this.markedForOffer;
        return true;
    }

    @Override
    public boolean isAllQuantityMarkedForOffer() {
        return this.markedForOffer >= this.quantity;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public boolean isInCategory(String categoryName) {
        Category currentCategory = this.category;
        if (currentCategory != null) {
            if (currentCategory.getName().equals(categoryName)) {
                return true;
            }
            while ((currentCategory = currentCategory.getDefaultParentCategory()) != null) {
                if (!currentCategory.getName().equals(categoryName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<OrderItemAdjustment> getOrderItemAdjustments() {
        return this.orderItemAdjustments;
    }

    @Override
    public void addOrderItemAdjustment(OrderItemAdjustment orderItemAdjustment) {
        if (this.orderItemAdjustments.size() == 0) {
            this.adjustmentPrice = this.retailPrice;
        }
        this.adjustmentPrice = this.adjustmentPrice.subtract(orderItemAdjustment.getValue().getAmount());
        this.orderItemAdjustments.add(orderItemAdjustment);
        if (!orderItemAdjustment.getOffer().isCombinableWithOtherOffers()) {
            this.notCombinableOfferApplied = true;
        }
        this.hasOrderItemAdjustments = true;
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = 0;
        if (this.orderItemAdjustments != null) {
            removedAdjustmentCount = this.orderItemAdjustments.size();
            this.orderItemAdjustments.clear();
        }
        this.adjustmentPrice = null;
        this.notCombinableOfferApplied = false;
        this.hasOrderItemAdjustments = false;
        return removedAdjustmentCount;
    }

    protected void setOrderItemAdjustments(List<OrderItemAdjustment> orderItemAdjustments) {
        this.orderItemAdjustments = orderItemAdjustments;
        if (orderItemAdjustments == null || orderItemAdjustments.size() == 0) {
            this.removeAllAdjustments();
        } else {
            for (OrderItemAdjustment orderItemAdjustment : orderItemAdjustments) {
                if (this.notCombinableOfferApplied) break;
                this.addOrderItemAdjustment(orderItemAdjustment);
            }
        }
    }

    @Override
    public Money getAdjustmentValue() {
        Money adjustmentValue = new Money(0);
        for (OrderItemAdjustment itemAdjustment : this.orderItemAdjustments) {
            adjustmentValue = adjustmentValue.add(itemAdjustment.getValue());
        }
        return adjustmentValue;
    }

    @Override
    public Money getAdjustmentPrice() {
        return this.adjustmentPrice == null ? null : new Money(this.adjustmentPrice);
    }

    @Override
    public void setAdjustmentPrice(Money adjustmentPrice) {
        this.adjustmentPrice = Money.toAmount((Money)adjustmentPrice);
    }

    @Override
    public GiftWrapOrderItem getGiftWrapOrderItem() {
        return this.giftWrapOrderItem;
    }

    @Override
    public void setGiftWrapOrderItem(GiftWrapOrderItem giftWrapOrderItem) {
        this.giftWrapOrderItem = giftWrapOrderItem;
    }

    @Override
    public OrderItemType getOrderItemType() {
        return this.orderItemType == null ? null : OrderItemType.getInstance(this.orderItemType);
    }

    @Override
    public void setOrderItemType(OrderItemType orderItemType) {
        this.orderItemType = orderItemType.getType();
    }

    @Override
    public boolean getIsOnSale() {
        return !this.getSalePrice().equals((Object)this.getRetailPrice());
    }

    @Override
    public boolean getIsDiscounted() {
        return !this.getPrice().equals((Object)this.getRetailPrice());
    }

    @Override
    public boolean isNotCombinableOfferApplied() {
        return this.notCombinableOfferApplied;
    }

    @Override
    public boolean isHasOrderItemAdjustments() {
        return this.hasOrderItemAdjustments;
    }

    @Override
    public boolean updatePrices() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adjustmentPrice == null ? 0 : this.adjustmentPrice.hashCode());
        result = 31 * result + (this.candidateItemOffers == null ? 0 : ((Object)this.candidateItemOffers).hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.giftWrapOrderItem == null ? 0 : this.giftWrapOrderItem.hashCode());
        result = 31 * result + this.markedForOffer;
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.orderItemAdjustments == null ? 0 : ((Object)this.orderItemAdjustments).hashCode());
        result = 31 * result + (this.orderItemType == null ? 0 : this.orderItemType.hashCode());
        result = 31 * result + (this.personalMessage == null ? 0 : this.personalMessage.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        result = 31 * result + this.quantity;
        result = 31 * result + (this.retailPrice == null ? 0 : this.retailPrice.hashCode());
        result = 31 * result + (this.salePrice == null ? 0 : this.salePrice.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemImpl other = (OrderItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.adjustmentPrice == null ? other.adjustmentPrice != null : !this.adjustmentPrice.equals(other.adjustmentPrice)) {
            return false;
        }
        if (this.candidateItemOffers == null ? other.candidateItemOffers != null : !((Object)this.candidateItemOffers).equals(other.candidateItemOffers)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.giftWrapOrderItem == null ? other.giftWrapOrderItem != null : !this.giftWrapOrderItem.equals(other.giftWrapOrderItem)) {
            return false;
        }
        if (this.markedForOffer != other.markedForOffer) {
            return false;
        }
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        if (this.orderItemAdjustments == null ? other.orderItemAdjustments != null : !((Object)this.orderItemAdjustments).equals(other.orderItemAdjustments)) {
            return false;
        }
        if (this.orderItemType == null ? other.orderItemType != null : !this.orderItemType.equals(other.orderItemType)) {
            return false;
        }
        if (this.personalMessage == null ? other.personalMessage != null : !this.personalMessage.equals(other.personalMessage)) {
            return false;
        }
        if (this.price == null ? other.price != null : !this.price.equals(other.price)) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        if (this.retailPrice == null ? other.retailPrice != null : !this.retailPrice.equals(other.retailPrice)) {
            return false;
        }
        return !(this.salePrice == null ? other.salePrice != null : !this.salePrice.equals(other.salePrice));
    }
}

