/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.common.domain.Auditable;
import org.broadleafcommerce.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.offer.domain.CandidateOrderOfferImpl;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.domain.OfferCode;
import org.broadleafcommerce.offer.domain.OfferCodeImpl;
import org.broadleafcommerce.offer.domain.OfferImpl;
import org.broadleafcommerce.offer.domain.OfferInfo;
import org.broadleafcommerce.offer.domain.OfferInfoImpl;
import org.broadleafcommerce.offer.domain.OrderAdjustment;
import org.broadleafcommerce.offer.domain.OrderAdjustmentImpl;
import org.broadleafcommerce.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.order.service.type.OrderStatus;
import org.broadleafcommerce.payment.domain.PaymentInfo;
import org.broadleafcommerce.payment.domain.PaymentInfoImpl;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.domain.CustomerImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.MapKeyManyToMany;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class OrderImpl
implements Order {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OrderId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="OrderImpl", allocationSize=50)
    @Column(name="ORDER_ID")
    protected Long id;
    @Embedded
    protected Auditable auditable = new Auditable();
    @Column(name="NAME")
    protected String name;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID", nullable=false)
    protected Customer customer;
    @Column(name="ORDER_STATUS")
    protected String status;
    @Column(name="CITY_TAX")
    protected BigDecimal cityTax;
    @Column(name="COUNTY_TAX")
    protected BigDecimal countyTax;
    @Column(name="STATE_TAX")
    protected BigDecimal stateTax;
    @Column(name="COUNTRY_TAX")
    protected BigDecimal countryTax;
    @Column(name="TOTAL_TAX")
    protected BigDecimal totalTax;
    @Column(name="TOTAL_SHIPPING")
    protected BigDecimal totalShipping;
    @Column(name="ORDER_SUBTOTAL")
    protected BigDecimal subTotal;
    @Column(name="ORDER_TOTAL")
    protected BigDecimal total;
    @Column(name="SUBMIT_DATE")
    protected Date submitDate;
    @Column(name="ORDER_NUMBER")
    private String orderNumber;
    @Column(name="EMAIL_ADDRESS")
    protected String emailAddress;
    @Transient
    protected BigDecimal adjustmentPrice;
    @OneToMany(mappedBy="order", targetEntity=OrderItemImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItem> orderItems = new ArrayList<OrderItem>();
    @OneToMany(mappedBy="order", targetEntity=FulfillmentGroupImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @OrderBy(value="id")
    protected List<FulfillmentGroup> fulfillmentGroups = new ArrayList<FulfillmentGroup>();
    @OneToMany(mappedBy="order", targetEntity=OrderAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderAdjustment> orderAdjustments = new ArrayList<OrderAdjustment>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=OfferCodeImpl.class)
    @JoinTable(name="BLC_ORDER_OFFER_CODE_XREF", joinColumns={@JoinColumn(name="ORDER_ID", referencedColumnName="ORDER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_CODE_ID", referencedColumnName="OFFER_CODE_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OfferCode> addedOfferCodes = new ArrayList<OfferCode>();
    @OneToMany(mappedBy="order", targetEntity=CandidateOrderOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateOrderOffer> candidateOrderOffers = new ArrayList<CandidateOrderOffer>();
    @OneToMany(mappedBy="order", targetEntity=PaymentInfoImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>();
    @ManyToMany(targetEntity=OfferInfoImpl.class)
    @JoinTable(name="BLC_ADDITIONAL_OFFER_INFO", inverseJoinColumns={@JoinColumn(name="OFFER_INFO_ID", referencedColumnName="OFFER_INFO_ID")})
    @MapKeyManyToMany(joinColumns={@JoinColumn(name="OFFER_ID")}, targetEntity=OfferImpl.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected Map<Offer, OfferInfo> additionalOfferInformation = new HashMap<Offer, OfferInfo>();
    @Transient
    protected boolean markedForOffer;
    @Transient
    protected boolean notCombinableOfferApplied = false;
    @Transient
    protected boolean hasOrderAdjustments = false;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    @Override
    public Money getSubTotal() {
        return this.subTotal == null ? null : new Money(this.subTotal);
    }

    @Override
    public void setSubTotal(Money subTotal) {
        this.subTotal = Money.toAmount((Money)subTotal);
    }

    @Override
    public Money calculateOrderItemsCurrentPrice() {
        Money calculatedSubTotal = new Money();
        for (OrderItem orderItem : this.orderItems) {
            Money currentItemPrice = orderItem.getCurrentPrice();
            calculatedSubTotal = calculatedSubTotal.add(new Money(currentItemPrice.doubleValue() * (double)orderItem.getQuantity()));
        }
        return calculatedSubTotal;
    }

    @Override
    public Money calculateOrderItemsFinalPrice() {
        Money calculatedSubTotal = new Money();
        for (OrderItem orderItem : this.orderItems) {
            Money currentItemPrice = orderItem.getPrice();
            calculatedSubTotal = calculatedSubTotal.add(new Money(currentItemPrice.doubleValue() * (double)orderItem.getQuantity()));
        }
        return calculatedSubTotal;
    }

    @Override
    public void assignOrderItemsFinalPrice() {
        for (OrderItem orderItem : this.orderItems) {
            orderItem.assignFinalPrice();
        }
    }

    @Override
    public Money getTotal() {
        return this.total == null ? null : new Money(this.total);
    }

    @Override
    public void setTotal(Money orderTotal) {
        this.total = Money.toAmount((Money)orderTotal);
    }

    @Override
    public Money getRemainingTotal() {
        Money myTotal = this.getTotal();
        if (myTotal == null) {
            return null;
        }
        Money totalPayments = new Money(BigDecimal.ZERO);
        for (PaymentInfo pi : this.getPaymentInfos()) {
            if (pi.getAmount() == null) continue;
            totalPayments = totalPayments.add(pi.getAmount());
        }
        return myTotal.subtract(totalPayments);
    }

    @Override
    public Date getSubmitDate() {
        return this.submitDate;
    }

    @Override
    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public OrderStatus getStatus() {
        return this.status == null ? null : OrderStatus.getInstance(this.status);
    }

    @Override
    public void setStatus(OrderStatus status) {
        this.status = status.getType();
    }

    @Override
    public List<OrderItem> getOrderItems() {
        return this.orderItems;
    }

    @Override
    public void setOrderItems(List<OrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    @Override
    public void addOrderItem(OrderItem orderItem) {
        this.orderItems.add(orderItem);
    }

    @Override
    public List<FulfillmentGroup> getFulfillmentGroups() {
        return this.fulfillmentGroups;
    }

    @Override
    public void setFulfillmentGroups(List<FulfillmentGroup> fulfillmentGroups) {
        this.fulfillmentGroups = fulfillmentGroups;
    }

    @Override
    public void setCandidateOrderOffers(List<CandidateOrderOffer> candidateOrderOffers) {
        this.candidateOrderOffers = candidateOrderOffers;
    }

    @Override
    public void addCandidateOrderOffer(CandidateOrderOffer candidateOrderOffer) {
        this.candidateOrderOffers.add(candidateOrderOffer);
    }

    @Override
    public List<CandidateOrderOffer> getCandidateOrderOffers() {
        return this.candidateOrderOffers;
    }

    @Override
    public void removeAllCandidateOffers() {
        this.removeAllCandidateOrderOffers();
        if (this.getOrderItems() != null) {
            for (OrderItem item : this.getOrderItems()) {
                item.removeAllCandidateItemOffers();
            }
        }
        if (this.getFulfillmentGroups() != null) {
            for (FulfillmentGroup fg : this.getFulfillmentGroups()) {
                fg.removeAllCandidateOffers();
            }
        }
    }

    @Override
    public void removeAllCandidateOrderOffers() {
        if (this.candidateOrderOffers != null) {
            this.candidateOrderOffers.clear();
        }
    }

    public boolean isMarkedForOffer() {
        return this.markedForOffer;
    }

    @Override
    public void setMarkedForOffer(boolean markedForOffer) {
        this.markedForOffer = markedForOffer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Money getCityTax() {
        return this.cityTax == null ? null : new Money(this.cityTax);
    }

    @Override
    public void setCityTax(Money cityTax) {
        this.cityTax = Money.toAmount((Money)cityTax);
    }

    @Override
    public Money getCountyTax() {
        return this.countyTax == null ? null : new Money(this.countyTax);
    }

    @Override
    public void setCountyTax(Money countyTax) {
        this.countyTax = Money.toAmount((Money)countyTax);
    }

    @Override
    public Money getStateTax() {
        return this.stateTax == null ? null : new Money(this.stateTax);
    }

    @Override
    public void setStateTax(Money stateTax) {
        this.stateTax = Money.toAmount((Money)stateTax);
    }

    @Override
    public Money getCountryTax() {
        return this.countryTax == null ? null : new Money(this.countryTax);
    }

    @Override
    public void setCountryTax(Money countryTax) {
        this.countryTax = Money.toAmount((Money)countryTax);
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : new Money(this.totalTax);
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    @Override
    public Money getTotalShipping() {
        return this.totalShipping == null ? null : new Money(this.totalShipping);
    }

    @Override
    public void setTotalShipping(Money totalShipping) {
        this.totalShipping = Money.toAmount((Money)totalShipping);
    }

    @Override
    public List<PaymentInfo> getPaymentInfos() {
        return this.paymentInfos;
    }

    @Override
    public void setPaymentInfos(List<PaymentInfo> paymentInfos) {
        this.paymentInfos = paymentInfos;
    }

    @Override
    public boolean hasCategoryItem(String categoryName) {
        for (OrderItem orderItem : this.orderItems) {
            if (!orderItem.isInCategory(categoryName)) continue;
            return true;
        }
        return false;
    }

    protected List<OrderAdjustment> getOrderAdjustments() {
        return this.orderAdjustments;
    }

    @Override
    public List<OrderAdjustment> addOrderAdjustments(OrderAdjustment orderAdjustment) {
        if (this.orderAdjustments.size() == 0) {
            this.adjustmentPrice = this.getSubTotal().getAmount();
        }
        this.adjustmentPrice = this.adjustmentPrice.subtract(orderAdjustment.getValue().getAmount());
        this.orderAdjustments.add(orderAdjustment);
        if (!orderAdjustment.getOffer().isCombinableWithOtherOffers()) {
            this.notCombinableOfferApplied = true;
        }
        this.hasOrderAdjustments = true;
        return this.orderAdjustments;
    }

    @Override
    public void removeAllAdjustments() {
        this.removeAllItemAdjustments();
        this.removeAllFulfillmentAdjustments();
        this.removeAllOrderAdjustments();
    }

    @Override
    public void removeAllOrderAdjustments() {
        if (this.orderAdjustments != null) {
            this.orderAdjustments.clear();
        }
        this.adjustmentPrice = null;
        this.notCombinableOfferApplied = false;
        this.hasOrderAdjustments = false;
    }

    @Override
    public void removeAllItemAdjustments() {
        for (OrderItem orderItem : this.orderItems) {
            orderItem.removeAllAdjustments();
        }
    }

    public void removeAllFulfillmentAdjustments() {
        for (FulfillmentGroup fulfillmentGroup : this.fulfillmentGroups) {
            fulfillmentGroup.removeAllAdjustments();
        }
    }

    protected void setOrderAdjustments(List<OrderAdjustment> orderAdjustments) {
        this.orderAdjustments = orderAdjustments;
    }

    @Override
    public Money getAdjustmentPrice() {
        return this.adjustmentPrice == null ? null : new Money(this.adjustmentPrice);
    }

    @Override
    public void setAdjustmentPrice(Money adjustmentPrice) {
        this.adjustmentPrice = Money.toAmount((Money)adjustmentPrice);
    }

    @Override
    public boolean containsNotStackableOrderOffer() {
        boolean isContainsNotStackableOrderOffer = false;
        for (OrderAdjustment orderAdjustment : this.orderAdjustments) {
            if (orderAdjustment.getOffer().isStackable()) continue;
            isContainsNotStackableOrderOffer = true;
            break;
        }
        return isContainsNotStackableOrderOffer;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        ArrayList<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
        for (OrderItem orderItem : this.orderItems) {
            if (orderItem instanceof BundleOrderItemImpl) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    discreteOrderItems.add(discreteOrderItem);
                }
                continue;
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            discreteOrderItems.add(discreteOrderItem);
        }
        return discreteOrderItems;
    }

    @Override
    public List<DiscreteOrderItem> getDiscountableDiscreteOrderItems() {
        ArrayList<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
        for (OrderItem orderItem : this.orderItems) {
            if (orderItem instanceof BundleOrderItemImpl) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (!discreteOrderItem.getSku().isDiscountable().booleanValue()) continue;
                    discreteOrderItems.add(discreteOrderItem);
                }
                continue;
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            if (!discreteOrderItem.getSku().isDiscountable().booleanValue()) continue;
            discreteOrderItems.add(discreteOrderItem);
        }
        return discreteOrderItems;
    }

    @Override
    public List<OfferCode> getAddedOfferCodes() {
        return this.addedOfferCodes;
    }

    @Override
    public void addAddedOfferCode(OfferCode addedOfferCode) {
        this.addedOfferCodes.add(addedOfferCode);
    }

    @Override
    public void removeAllAddedOfferCodes() {
        if (this.addedOfferCodes != null) {
            this.addedOfferCodes.clear();
        }
    }

    @Override
    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Override
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Override
    public String getFulfillmentStatus() {
        return null;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public Map<Offer, OfferInfo> getAdditionalOfferInformation() {
        return this.additionalOfferInformation;
    }

    @Override
    public void setAdditionalOfferInformation(Map<Offer, OfferInfo> additionalOfferInformation) {
        this.additionalOfferInformation = additionalOfferInformation;
    }

    @Override
    public Money getItemAdjustmentsValue() {
        Money itemAdjustmentsValue = new Money(0);
        for (OrderItem orderItem : this.orderItems) {
            itemAdjustmentsValue = itemAdjustmentsValue.add(orderItem.getAdjustmentValue().multiply(orderItem.getQuantity()));
        }
        return itemAdjustmentsValue;
    }

    @Override
    public Money getOrderAdjustmentsValue() {
        Money orderAdjustmentsValue = new Money(0);
        for (OrderAdjustment orderAdjustment : this.orderAdjustments) {
            orderAdjustmentsValue = orderAdjustmentsValue.add(orderAdjustment.getValue());
        }
        return orderAdjustmentsValue;
    }

    @Override
    public Money getTotalAdjustmentsValue() {
        Money totalAdjustmentsValue = this.getItemAdjustmentsValue();
        totalAdjustmentsValue = totalAdjustmentsValue.add(this.getOrderAdjustmentsValue());
        return totalAdjustmentsValue;
    }

    @Override
    public boolean isNotCombinableOfferApplied() {
        return this.notCombinableOfferApplied;
    }

    @Override
    public boolean isHasOrderAdjustments() {
        return this.hasOrderAdjustments;
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        for (OrderItem orderItem : this.orderItems) {
            if (!orderItem.updatePrices()) continue;
            updated = true;
        }
        return updated;
    }

    public boolean equals(Object obj) {
        Date otherDateCreated;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderImpl other = (OrderImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        Date myDateCreated = this.auditable != null ? this.auditable.getDateCreated() : null;
        Date date = otherDateCreated = other.auditable != null ? other.auditable.getDateCreated() : null;
        return !(myDateCreated == null ? otherDateCreated != null : !myDateCreated.equals(otherDateCreated));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        Date myDateCreated = this.auditable != null ? this.auditable.getDateCreated() : null;
        result = 31 * result + (myDateCreated == null ? 0 : myDateCreated.hashCode());
        return result;
    }
}

