/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupItemImpl
implements FulfillmentGroupItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupItemImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_ITEM_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    protected FulfillmentGroup fulfillmentGroup;
    @OneToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;
    @Column(name="QUANTITY", nullable=false)
    protected int quantity;
    @Column(name="RETAIL_PRICE")
    protected BigDecimal retailPrice;
    @Column(name="SALE_PRICE")
    protected BigDecimal salePrice;
    @Column(name="PRICE")
    protected BigDecimal price;
    @Column(name="STATUS")
    private String status;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Money getRetailPrice() {
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getSalePrice() {
        return this.salePrice == null ? null : new Money(this.salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getPrice() {
        return this.price == null ? null : new Money(this.price);
    }

    @Override
    public void setPrice(Money price) {
        this.price = Money.toAmount((Money)price);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupItemImpl other = (FulfillmentGroupItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        return result;
    }
}

