/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.order.domain.FulfillmentGroupFeeImpl;
import org.broadleafcommerce.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderImpl;
import org.broadleafcommerce.order.domain.PersonalMessage;
import org.broadleafcommerce.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.profile.domain.Address;
import org.broadleafcommerce.profile.domain.AddressImpl;
import org.broadleafcommerce.profile.domain.Phone;
import org.broadleafcommerce.profile.domain.PhoneImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupImpl
implements FulfillmentGroup {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    protected Order order;
    @Column(name="REFERENCE_NUMBER")
    protected String referenceNumber;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupItemImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupItem> fulfillmentGroupItems = new ArrayList<FulfillmentGroupItem>();
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    protected Phone phone;
    @Column(name="METHOD")
    protected String method;
    @Column(name="RETAIL_PRICE")
    protected BigDecimal retailShippingPrice;
    @Column(name="SALE_PRICE")
    protected BigDecimal saleShippingPrice;
    @Column(name="PRICE")
    protected BigDecimal shippingPrice;
    @Transient
    protected BigDecimal adjustmentPrice;
    @Column(name="TYPE")
    protected String type = FulfillmentGroupType.SHIPPING.getType();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=CandidateFulfillmentGroupOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateFulfillmentGroupOffer> candidateOffers = new ArrayList<CandidateFulfillmentGroupOffer>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments = new ArrayList<FulfillmentGroupAdjustment>();
    @Column(name="CITY_TAX")
    protected BigDecimal cityTax;
    @Column(name="COUNTY_TAX")
    protected BigDecimal countyTax;
    @Column(name="STATE_TAX")
    protected BigDecimal stateTax;
    @Column(name="COUNTRY_TAX")
    protected BigDecimal countryTax;
    @Column(name="TOTAL_TAX")
    protected BigDecimal totalTax;
    @Column(name="DELIVERY_INSTRUCTION")
    protected String deliveryInstruction;
    @Column(name="IS_PRIMARY")
    protected boolean primary = false;
    @ManyToOne(targetEntity=PersonalMessageImpl.class)
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    protected PersonalMessage personalMessage;
    @Column(name="MERCHANDISE_TOTAL")
    protected BigDecimal merchandiseTotal;
    @Column(name="TOTAL")
    protected BigDecimal total;
    @Column(name="STATUS")
    protected String status;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupFeeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupFee> fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public List<FulfillmentGroupItem> getFulfillmentGroupItems() {
        return this.fulfillmentGroupItems;
    }

    @Override
    public void setFulfillmentGroupItems(List<FulfillmentGroupItem> fulfillmentGroupItems) {
        this.fulfillmentGroupItems = fulfillmentGroupItems;
    }

    @Override
    public void addFulfillmentGroupItem(FulfillmentGroupItem fulfillmentGroupItem) {
        if (this.fulfillmentGroupItems == null) {
            this.fulfillmentGroupItems = new Vector<FulfillmentGroupItem>();
        }
        this.fulfillmentGroupItems.add(fulfillmentGroupItem);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String fulfillmentMethod) {
        this.method = fulfillmentMethod;
    }

    @Override
    public Money getRetailShippingPrice() {
        return this.retailShippingPrice == null ? null : new Money(this.retailShippingPrice);
    }

    @Override
    public void setRetailShippingPrice(Money retailShippingPrice) {
        this.retailShippingPrice = Money.toAmount((Money)retailShippingPrice);
    }

    @Override
    public FulfillmentGroupType getType() {
        return this.type == null ? null : FulfillmentGroupType.getInstance(this.type);
    }

    @Override
    public void setType(FulfillmentGroupType type) {
        this.type = type.getType();
    }

    @Override
    public void addCandidateFulfillmentGroupOffer(CandidateFulfillmentGroupOffer candidateOffer) {
        this.candidateOffers.add(candidateOffer);
    }

    @Override
    public List<CandidateFulfillmentGroupOffer> getCandidateFulfillmentGroupOffers() {
        return this.candidateOffers;
    }

    @Override
    public void setCandidateFulfillmentGroupOffer(List<CandidateFulfillmentGroupOffer> candidateOffers) {
        this.candidateOffers = candidateOffers;
    }

    @Override
    public void removeAllCandidateOffers() {
        if (this.candidateOffers != null) {
            this.candidateOffers.clear();
        }
    }

    @Override
    public List<FulfillmentGroupAdjustment> getFulfillmentGroupAdjustments() {
        return this.fulfillmentGroupAdjustments;
    }

    @Override
    public List<FulfillmentGroupAdjustment> addFulfillmentGroupAdjustment(FulfillmentGroupAdjustment fulfillmentGroupAdjustment) {
        if (this.fulfillmentGroupAdjustments.size() == 0) {
            this.adjustmentPrice = this.retailShippingPrice;
        }
        this.adjustmentPrice = this.adjustmentPrice.subtract(fulfillmentGroupAdjustment.getValue().getAmount());
        this.fulfillmentGroupAdjustments.add(fulfillmentGroupAdjustment);
        return this.fulfillmentGroupAdjustments;
    }

    @Override
    public void removeAllAdjustments() {
        if (this.fulfillmentGroupAdjustments != null) {
            this.fulfillmentGroupAdjustments.clear();
        }
        this.adjustmentPrice = null;
    }

    @Override
    public void setFulfillmentGroupAdjustments(List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments) {
        this.fulfillmentGroupAdjustments = fulfillmentGroupAdjustments;
    }

    @Override
    public Money getSaleShippingPrice() {
        return this.saleShippingPrice == null ? null : new Money(this.saleShippingPrice);
    }

    @Override
    public void setSaleShippingPrice(Money saleShippingPrice) {
        this.saleShippingPrice = Money.toAmount((Money)saleShippingPrice);
    }

    @Override
    public Money getShippingPrice() {
        return this.shippingPrice == null ? null : new Money(this.shippingPrice);
    }

    @Override
    public void setShippingPrice(Money shippingPrice) {
        this.shippingPrice = Money.toAmount((Money)shippingPrice);
    }

    @Override
    public Money getAdjustmentPrice() {
        return this.adjustmentPrice == null ? null : new Money(this.adjustmentPrice);
    }

    @Override
    public void setAdjustmentPrice(Money adjustmentPrice) {
        this.adjustmentPrice = Money.toAmount((Money)adjustmentPrice);
    }

    @Override
    public Money getCityTax() {
        return this.cityTax == null ? null : new Money(this.cityTax);
    }

    @Override
    public void setCityTax(Money cityTax) {
        this.cityTax = Money.toAmount((Money)cityTax);
    }

    @Override
    public Money getCountyTax() {
        return this.countyTax == null ? null : new Money(this.countyTax);
    }

    @Override
    public void setCountyTax(Money countyTax) {
        this.countyTax = Money.toAmount((Money)countyTax);
    }

    @Override
    public Money getStateTax() {
        return this.stateTax == null ? null : new Money(this.stateTax);
    }

    @Override
    public void setStateTax(Money stateTax) {
        this.stateTax = Money.toAmount((Money)stateTax);
    }

    @Override
    public Money getCountryTax() {
        return this.countryTax == null ? null : new Money(this.countryTax);
    }

    @Override
    public void setCountryTax(Money countryTax) {
        this.countryTax = Money.toAmount((Money)countryTax);
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : new Money(this.totalTax);
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    @Override
    public String getDeliveryInstruction() {
        return this.deliveryInstruction;
    }

    @Override
    public void setDeliveryInstruction(String deliveryInstruction) {
        this.deliveryInstruction = deliveryInstruction;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public Money getMerchandiseTotal() {
        return this.merchandiseTotal == null ? null : new Money(this.merchandiseTotal);
    }

    @Override
    public void setMerchandiseTotal(Money merchandiseTotal) {
        this.merchandiseTotal = Money.toAmount((Money)merchandiseTotal);
    }

    @Override
    public Money getTotal() {
        return this.total == null ? null : new Money(this.total);
    }

    @Override
    public void setTotal(Money orderTotal) {
        this.total = Money.toAmount((Money)orderTotal);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.fulfillmentGroupItems == null ? 0 : ((Object)this.fulfillmentGroupItems).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupImpl other = (FulfillmentGroupImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.fulfillmentGroupItems == null ? other.fulfillmentGroupItems != null : !((Object)this.fulfillmentGroupItems).equals(other.fulfillmentGroupItems));
    }

    @Override
    public FulfillmentGroupStatusType getStatus() {
        return this.status == null ? null : FulfillmentGroupStatusType.getInstance(this.status);
    }

    public void setStatus(FulfillmentGroupStatusType status) {
        this.status = status.getType();
    }

    @Override
    public List<FulfillmentGroupFee> getFulfillmentGroupFees() {
        return this.fulfillmentGroupFees;
    }

    @Override
    public void setFulfillmentGroupFees(List<FulfillmentGroupFee> fulfillmentGroupFees) {
        this.fulfillmentGroupFees = fulfillmentGroupFees;
    }

    @Override
    public void addFulfillmentGroupFee(FulfillmentGroupFee fulfillmentGroupFee) {
        if (this.fulfillmentGroupFees == null) {
            this.fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
        }
        this.fulfillmentGroupFees.add(fulfillmentGroupFee);
    }

    @Override
    public void removeAllFulfillmentGroupFees() {
        if (this.fulfillmentGroupFees != null) {
            this.fulfillmentGroupFees.clear();
        }
    }
}

