/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.domain.ProductImpl;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.catalog.domain.SkuImpl;
import org.broadleafcommerce.order.domain.BundleOrderItem;
import org.broadleafcommerce.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_DISCRETE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class DiscreteOrderItemImpl
extends OrderItemImpl
implements DiscreteOrderItem {
    private static final long serialVersionUID = 1L;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false)
    @JoinColumn(name="SKU_ID", nullable=false)
    protected Sku sku;
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="PRODUCT_ID")
    @NotFound(action=NotFoundAction.IGNORE)
    protected Product product;
    @ManyToOne(targetEntity=BundleOrderItemImpl.class)
    @JoinColumn(name="BUNDLE_ORDER_ITEM_ID")
    protected BundleOrderItem bundleOrderItem;

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
        if (sku.getRetailPrice() != null) {
            this.retailPrice = sku.getRetailPrice().getAmount();
        }
        if (sku.getSalePrice() != null) {
            this.salePrice = sku.getSalePrice().getAmount();
        }
    }

    @Override
    public Money getTaxablePrice() {
        Money taxablePrice = new Money(0.0);
        if (this.sku.isTaxable().booleanValue()) {
            taxablePrice = this.getPrice();
        }
        return taxablePrice;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public BundleOrderItem getBundleOrderItem() {
        return this.bundleOrderItem;
    }

    @Override
    public void setBundleOrderItem(BundleOrderItem bundleOrderItem) {
        this.bundleOrderItem = bundleOrderItem;
    }

    @Override
    public String getName() {
        return this.getSku().getName();
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        if (!this.getSku().getRetailPrice().equals((Object)this.getRetailPrice())) {
            this.setRetailPrice(this.getSku().getRetailPrice());
            updated = true;
        }
        if (this.getSku().getSalePrice() != null && !this.getSku().getSalePrice().equals((Object)this.getSalePrice())) {
            this.setSalePrice(this.getSku().getSalePrice());
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteOrderItemImpl other = (DiscreteOrderItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.bundleOrderItem == null ? other.bundleOrderItem != null : !this.bundleOrderItem.equals(other.bundleOrderItem)) {
            return false;
        }
        return !(this.sku == null ? other.sku != null : !this.sku.equals(other.sku));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleOrderItem == null ? 0 : this.bundleOrderItem.hashCode());
        result = 31 * result + (this.sku == null ? 0 : this.sku.hashCode());
        return result;
    }
}

