/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.order.domain.BundleOrderItem;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BUNDLE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class BundleOrderItemImpl
extends OrderItemImpl
implements BundleOrderItem {
    private static final long serialVersionUID = 1L;
    @Column(name="NAME")
    protected String name;
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=DiscreteOrderItemImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        return this.discreteOrderItems;
    }

    @Override
    public void setDiscreteOrderItems(List<DiscreteOrderItem> discreteOrderItems) {
        this.discreteOrderItems = discreteOrderItems;
    }

    @Override
    public void removeAllCandidateItemOffers() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            discreteOrderItem.removeAllCandidateItemOffers();
        }
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = 0;
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            removedAdjustmentCount += discreteOrderItem.removeAllAdjustments();
        }
        return removedAdjustmentCount;
    }

    @Override
    public void assignFinalPrice() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            discreteOrderItem.assignFinalPrice();
        }
        this.price = this.getCurrentPrice().getAmount();
    }

    @Override
    public Money getTaxablePrice() {
        Money currentBundleTaxablePrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money currentItemTaxablePrice = discreteOrderItem.getTaxablePrice();
            currentBundleTaxablePrice = currentBundleTaxablePrice.add(new Money(currentItemTaxablePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        return currentBundleTaxablePrice;
    }

    @Override
    public Money getRetailPrice() {
        Money bundleRetailPrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money itemRetailPrice = discreteOrderItem.getRetailPrice();
            bundleRetailPrice = bundleRetailPrice.add(new Money(itemRetailPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        return bundleRetailPrice;
    }

    @Override
    public Money getSalePrice() {
        Money bundleSalePrice = null;
        if (this.hasSaleItems()) {
            bundleSalePrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money itemSalePrice = null;
                itemSalePrice = discreteOrderItem.getSalePrice() != null ? discreteOrderItem.getSalePrice() : discreteOrderItem.getRetailPrice();
                bundleSalePrice = bundleSalePrice.add(new Money(itemSalePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
        }
        return bundleSalePrice;
    }

    private boolean hasSaleItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (discreteOrderItem.getSalePrice() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Money getAdjustmentPrice() {
        Money bundleAdjustmentPrice = null;
        if (this.hasAdjustmentItems()) {
            bundleAdjustmentPrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money itemAdjustmentPrice = null;
                itemAdjustmentPrice = discreteOrderItem.getAdjustmentPrice() != null ? discreteOrderItem.getAdjustmentPrice() : (discreteOrderItem.getSalePrice() != null ? discreteOrderItem.getSalePrice() : discreteOrderItem.getRetailPrice());
                bundleAdjustmentPrice = bundleAdjustmentPrice.add(new Money(itemAdjustmentPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
        }
        return bundleAdjustmentPrice;
    }

    private boolean hasAdjustmentItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (discreteOrderItem.getAdjustmentPrice() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Money getCurrentPrice() {
        Money currentBundlePrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money currentItemPrice = discreteOrderItem.getCurrentPrice();
            currentBundlePrice = currentBundlePrice.add(new Money(currentItemPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        return currentBundlePrice;
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (!discreteOrderItem.updatePrices()) continue;
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleOrderItemImpl other = (BundleOrderItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

