/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.broadleafcommerce.order.dao.OrderItemDao;
import org.broadleafcommerce.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.order.domain.PersonalMessage;
import org.broadleafcommerce.order.service.type.OrderItemType;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blOrderItemDao")
public class OrderItemDaoImpl
implements OrderItemDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OrderItem save(OrderItem orderItem) {
        if (orderItem.getId() == null) {
            this.em.persist((Object)orderItem);
        } else {
            orderItem = (OrderItem)this.em.merge((Object)orderItem);
        }
        return orderItem;
    }

    @Override
    public OrderItem readOrderItemById(Long orderItemId) {
        return (OrderItem)this.em.find(OrderItemImpl.class, (Object)orderItemId);
    }

    @Override
    public void delete(OrderItem orderItem) {
        if (GiftWrapOrderItem.class.isAssignableFrom(orderItem.getClass())) {
            GiftWrapOrderItem giftItem = (GiftWrapOrderItem)orderItem;
            for (OrderItem wrappedItem : giftItem.getWrappedItems()) {
                wrappedItem.setGiftWrapOrderItem(null);
                this.save(wrappedItem);
            }
        }
        this.em.remove((Object)orderItem);
    }

    @Override
    public OrderItem create(OrderItemType orderItemType) {
        OrderItem item = (OrderItem)this.entityConfiguration.createEntityInstance(orderItemType.getType());
        item.setOrderItemType(orderItemType);
        return item;
    }

    @Override
    public PersonalMessage createPersonalMessage() {
        PersonalMessage personalMessage = (PersonalMessage)this.entityConfiguration.createEntityInstance(PersonalMessage.class.getName());
        return personalMessage;
    }

    @Override
    public OrderItem saveOrderItem(OrderItem orderItem) {
        return (OrderItem)this.em.merge((Object)orderItem);
    }
}

