/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.order.dao.OrderDao;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.service.type.OrderStatus;
import org.broadleafcommerce.profile.dao.CustomerDao;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.broadleafcommerce.time.SystemTime;
import org.springframework.stereotype.Repository;

@Repository(value="blOrderDao")
public class OrderDaoImpl
implements OrderDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;

    @Override
    public Order readOrderById(Long orderId) {
        return (Order)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.order.domain.Order"), (Object)orderId);
    }

    @Override
    public Order save(Order order) {
        if (order.getAuditable() != null) {
            order.getAuditable().setDateUpdated(SystemTime.asDate());
        }
        if (order.getId() == null) {
            this.em.persist((Object)order);
        } else {
            order = (Order)this.em.merge((Object)order);
        }
        return order;
    }

    @Override
    public void delete(Order salesOrder) {
        this.em.remove((Object)salesOrder);
    }

    @Override
    public List<Order> readOrdersForCustomer(Customer customer, OrderStatus orderStatus) {
        if (orderStatus == null) {
            return this.readOrdersForCustomer(customer.getId());
        }
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_STATUS");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)orderStatus.getType());
        return query.getResultList();
    }

    @Override
    public List<Order> readOrdersForCustomer(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public Order readCartForCustomer(Customer customer) {
        Order order = null;
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_NAME_NULL");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.IN_PROCESS.getType());
        List temp = query.getResultList();
        if (temp.size() > 0) {
            order = (Order)temp.get(0);
        }
        return order;
    }

    @Override
    public Order createNewCartForCustomer(Customer customer) {
        Order order = this.create();
        if (customer.getUsername() == null) {
            customer.setUsername(String.valueOf(customer.getId()));
            customer = this.customerDao.save(customer);
        }
        order.setCustomer(customer);
        order.setEmailAddress(customer.getEmailAddress());
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.save(order);
        return order;
    }

    @Override
    public Order submitOrder(Order cartOrder) {
        cartOrder.setStatus(OrderStatus.SUBMITTED);
        return this.save(cartOrder);
    }

    @Override
    public Order create() {
        Order order = (Order)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.order.domain.Order");
        order.getAuditable().setDateCreated(SystemTime.asDate());
        return order;
    }

    @Override
    public Order updatePrices(Order order) {
        if ((order = (Order)this.em.merge((Object)order)).updatePrices()) {
            order = this.save(order);
        }
        return order;
    }

    @Override
    public Order readNamedOrderForCustomer(Customer customer, String name) {
        Query query = this.em.createNamedQuery("BC_READ_NAMED_ORDER_FOR_CUSTOMER");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.NAMED.getType());
        query.setParameter("orderName", (Object)name);
        List orders = query.getResultList();
        return orders == null || orders.isEmpty() ? null : (Order)orders.get(0);
    }

    @Override
    public Order readOrderByOrderNumber(String orderNumber) {
        if (orderNumber == null || "".equals(orderNumber)) {
            return null;
        }
        Order order = null;
        Query query = this.em.createNamedQuery("BC_READ_ORDER_BY_ORDER_NUMBER");
        query.setParameter("orderNumber", (Object)orderNumber);
        List result = query.getResultList();
        if (result.size() > 0) {
            order = (Order)result.get(0);
        }
        return order;
    }
}

