/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.order.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blFulfillmentGroupDao")
public class FulfillmentGroupDaoImpl
implements FulfillmentGroupDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public FulfillmentGroup save(FulfillmentGroup fulfillmentGroup) {
        fulfillmentGroup = (FulfillmentGroup)this.em.merge((Object)fulfillmentGroup);
        return fulfillmentGroup;
    }

    @Override
    public FulfillmentGroup readFulfillmentGroupById(Long fulfillmentGroupId) {
        return (FulfillmentGroup)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.order.domain.FulfillmentGroup"), (Object)fulfillmentGroupId);
    }

    @Override
    public FulfillmentGroupImpl readDefaultFulfillmentGroupForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_DEFAULT_FULFILLMENT_GROUP_BY_ORDER_ID");
        query.setParameter("orderId", (Object)order.getId());
        List fulfillmentGroups = query.getResultList();
        return fulfillmentGroups == null || fulfillmentGroups.isEmpty() ? null : (FulfillmentGroupImpl)fulfillmentGroups.get(0);
    }

    @Override
    public void delete(FulfillmentGroup fulfillmentGroup) {
        this.em.remove((Object)fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup createDefault() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.order.domain.FulfillmentGroup");
        fg.setPrimary(true);
        fg.setType(FulfillmentGroupType.SHIPPING);
        return fg;
    }

    @Override
    public FulfillmentGroup create() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.order.domain.FulfillmentGroup");
        fg.setType(FulfillmentGroupType.SHIPPING);
        return fg;
    }
}

