/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.map.LRUMap;
import org.broadleafcommerce.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.offer.dao.OfferCodeDao;
import org.broadleafcommerce.offer.dao.OfferDao;
import org.broadleafcommerce.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.offer.domain.CustomerOffer;
import org.broadleafcommerce.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.domain.OfferCode;
import org.broadleafcommerce.offer.domain.OrderAdjustment;
import org.broadleafcommerce.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.offer.service.OfferService;
import org.broadleafcommerce.offer.service.type.OfferType;
import org.broadleafcommerce.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.time.SystemTime;
import org.broadleafcommerce.util.money.Money;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.springframework.stereotype.Service;

@Service(value="blOfferService")
public class OfferServiceImpl
implements OfferService {
    private static final LRUMap expressionCache = new LRUMap(100);
    @Resource(name="blCustomerOfferDao")
    protected CustomerOfferDao customerOfferDao;
    @Resource(name="blOfferCodeDao")
    protected OfferCodeDao offerCodeDao;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;

    @Override
    public List<Offer> findAllOffers() {
        return this.offerDao.readAllOffers();
    }

    @Override
    public Offer save(Offer offer) {
        return this.offerDao.save(offer);
    }

    @Override
    public OfferCode saveOfferCode(OfferCode offerCode) {
        offerCode.setOffer(this.offerDao.save(offerCode.getOffer()));
        return this.offerCodeDao.save(offerCode);
    }

    @Override
    public Offer lookupOfferByCode(String code) {
        Offer offer = null;
        OfferCode offerCode = this.offerCodeDao.readOfferCodeByCode(code);
        if (offerCode != null) {
            offer = offerCode.getOffer();
        }
        return offer;
    }

    @Override
    public List<Offer> buildOfferListForOrder(Order order) {
        ArrayList<Offer> offers = new ArrayList<Offer>();
        List<CustomerOffer> customerOffers = this.lookupOfferCustomerByCustomer(order.getCustomer());
        for (CustomerOffer customerOffer : customerOffers) {
            if (offers.contains(customerOffer.getOffer())) continue;
            offers.add(customerOffer.getOffer());
        }
        List<OfferCode> orderOfferCodes = order.getAddedOfferCodes();
        orderOfferCodes = this.removeOutOfDateOfferCodes(orderOfferCodes);
        for (OfferCode orderOfferCode : orderOfferCodes) {
            if (offers.contains(orderOfferCode.getOffer())) continue;
            offers.add(orderOfferCode.getOffer());
        }
        List<Offer> globalOffers = this.lookupAutomaticDeliveryOffers();
        for (Offer globalOffer : globalOffers) {
            if (offers.contains(globalOffer)) continue;
            offers.add(globalOffer);
        }
        return offers;
    }

    protected List<CustomerOffer> lookupOfferCustomerByCustomer(Customer customer) {
        List<CustomerOffer> offerCustomers = this.customerOfferDao.readCustomerOffersByCustomer(customer);
        return offerCustomers;
    }

    protected List<Offer> lookupAutomaticDeliveryOffers() {
        List<Offer> globalOffers = this.offerDao.readOffersByAutomaticDeliveryType();
        return globalOffers;
    }

    protected List<OfferCode> removeOutOfDateOfferCodes(List<OfferCode> offerCodes) {
        Date now = SystemTime.asDate();
        ArrayList<OfferCode> offerCodesToRemove = new ArrayList<OfferCode>();
        for (OfferCode offerCode : offerCodes) {
            if (offerCode.getStartDate() != null && offerCode.getStartDate().after(now)) {
                offerCodesToRemove.add(offerCode);
                continue;
            }
            if (offerCode.getEndDate() == null || !offerCode.getEndDate().before(now)) continue;
            offerCodesToRemove.add(offerCode);
        }
        for (OfferCode offerCode : offerCodesToRemove) {
            offerCodes.remove(offerCode);
        }
        return offerCodes;
    }

    @Override
    public void applyOffersToOrder(List<Offer> offers, Order order) throws PricingException {
        this.clearOffersandAdjustments(order);
        List<Offer> filteredOffers = this.filterOffers(offers, order.getCustomer());
        if (filteredOffers == null || filteredOffers.isEmpty()) {
            order.assignOrderItemsFinalPrice();
            order.setSubTotal(order.calculateOrderItemsFinalPrice());
        } else {
            List<CandidateOrderOffer> qualifiedOrderOffers = new ArrayList<CandidateOrderOffer>();
            ArrayList<CandidateItemOffer> qualifiedItemOffers = new ArrayList<CandidateItemOffer>();
            order.setSubTotal(order.calculateOrderItemsCurrentPrice());
            List<DiscreteOrderItem> discreteOrderItems = order.getDiscountableDiscreteOrderItems();
            for (Offer offer : filteredOffers) {
                Serializable candidateOffer;
                if (offer.getType().equals(OfferType.ORDER)) {
                    if (!this.couldOfferApplyToOrder(offer, order)) continue;
                    CandidateOrderOffer candidateOffer2 = this.offerDao.createCandidateOrderOffer();
                    candidateOffer2.setOrder(order);
                    candidateOffer2.setOffer(offer);
                    order.addCandidateOrderOffer(candidateOffer2);
                    qualifiedOrderOffers.add(candidateOffer2);
                    continue;
                }
                if (offer.getType().equals(OfferType.ORDER_ITEM)) {
                    for (DiscreteOrderItem discreteOrderItem : discreteOrderItems) {
                        if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem)) continue;
                        candidateOffer = this.offerDao.createCandidateItemOffer();
                        candidateOffer.setOrderItem(discreteOrderItem);
                        candidateOffer.setOffer(offer);
                        discreteOrderItem.addCandidateItemOffer((CandidateItemOffer)candidateOffer);
                        qualifiedItemOffers.add((CandidateItemOffer)candidateOffer);
                    }
                    continue;
                }
                if (!offer.getType().equals(OfferType.FULFILLMENT_GROUP)) continue;
                for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                    if (!this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) continue;
                    candidateOffer = this.offerDao.createCandidateFulfillmentGroupOffer();
                    candidateOffer.setFulfillmentGroup(fulfillmentGroup);
                    candidateOffer.setOffer(offer);
                    fulfillmentGroup.addCandidateFulfillmentGroupOffer((CandidateFulfillmentGroupOffer)candidateOffer);
                }
            }
            if (qualifiedItemOffers.isEmpty() && qualifiedOrderOffers.isEmpty()) {
                order.assignOrderItemsFinalPrice();
                order.setSubTotal(order.calculateOrderItemsFinalPrice());
            } else {
                if (!qualifiedItemOffers.isEmpty()) {
                    Collections.sort(qualifiedItemOffers, new BeanComparator("discountAmount", Collections.reverseOrder()));
                    Collections.sort(qualifiedItemOffers, new BeanComparator("priority"));
                    this.applyAllItemOffers(qualifiedItemOffers, discreteOrderItems);
                }
                if (!qualifiedOrderOffers.isEmpty()) {
                    Collections.sort(qualifiedOrderOffers, new BeanComparator("discountAmount", Collections.reverseOrder()));
                    Collections.sort(qualifiedOrderOffers, new BeanComparator("priority"));
                    qualifiedOrderOffers = this.removeTrailingNotCombinableOrderOffers(qualifiedOrderOffers);
                    this.applyAllOrderOffers(qualifiedOrderOffers, order);
                }
                order.assignOrderItemsFinalPrice();
                order.setSubTotal(order.calculateOrderItemsFinalPrice());
                if (!qualifiedOrderOffers.isEmpty() && !qualifiedItemOffers.isEmpty()) {
                    ArrayList<CandidateOrderOffer> finalQualifiedOrderOffers = new ArrayList<CandidateOrderOffer>();
                    order.removeAllOrderAdjustments();
                    for (CandidateOrderOffer condidateOrderOffer : qualifiedOrderOffers) {
                        if (!this.couldOfferApplyToOrder(condidateOrderOffer.getOffer(), order)) continue;
                        finalQualifiedOrderOffers.add(condidateOrderOffer);
                    }
                    Collections.sort(finalQualifiedOrderOffers, new BeanComparator("discountedPrice"));
                    Collections.sort(finalQualifiedOrderOffers, new BeanComparator("priority"));
                    if (!finalQualifiedOrderOffers.isEmpty()) {
                        this.applyAllOrderOffers(finalQualifiedOrderOffers, order);
                    }
                }
            }
        }
    }

    protected List<CandidateOrderOffer> removeTrailingNotCombinableOrderOffers(List<CandidateOrderOffer> candidateOffers) {
        ArrayList<CandidateOrderOffer> remainingCandidateOffers = new ArrayList<CandidateOrderOffer>();
        int offerCount = 0;
        for (CandidateOrderOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else if (candidateOffer.getOffer().isCombinableWithOtherOffers()) {
                remainingCandidateOffers.add(candidateOffer);
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    protected List<CandidateItemOffer> removeTrailingNotCombinableItemOffers(List<CandidateItemOffer> candidateOffers) {
        ArrayList<CandidateItemOffer> remainingCandidateOffers = new ArrayList<CandidateItemOffer>();
        int offerCount = 0;
        Offer notCombinableOfferApplied = null;
        for (CandidateItemOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
                if (!candidateOffer.getOffer().isCombinableWithOtherOffers()) {
                    notCombinableOfferApplied = candidateOffer.getOffer();
                }
            } else if (candidateOffer.getOffer().isCombinableWithOtherOffers()) {
                remainingCandidateOffers.add(candidateOffer);
            } else if (candidateOffer.getOffer().equals(notCombinableOfferApplied)) {
                remainingCandidateOffers.add(candidateOffer);
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    protected List<CandidateOrderOffer> removeOfferFromCandidateOrderOffers(List<CandidateOrderOffer> candidateOffers, Offer offer) {
        ArrayList<CandidateOrderOffer> remainingCandidateOffers = new ArrayList<CandidateOrderOffer>();
        for (CandidateOrderOffer candidateOffer : candidateOffers) {
            if (candidateOffer.getOffer().equals(offer)) continue;
            remainingCandidateOffers.add(candidateOffer);
        }
        return remainingCandidateOffers;
    }

    protected List<CandidateItemOffer> removeOfferFromCandidateItemOffers(List<CandidateItemOffer> candidateOffers, Offer offer) {
        ArrayList<CandidateItemOffer> remainingCandidateOffers = new ArrayList<CandidateItemOffer>();
        for (CandidateItemOffer candidateOffer : candidateOffers) {
            if (candidateOffer.getOffer().equals(offer)) continue;
            remainingCandidateOffers.add(candidateOffer);
        }
        return remainingCandidateOffers;
    }

    protected void clearOffersandAdjustments(Order order) {
        order.removeAllCandidateOffers();
        order.removeAllAdjustments();
    }

    protected List<Offer> filterOffers(List<Offer> offers, Customer customer) {
        List<Offer> filteredOffers = null;
        if (offers != null && !offers.isEmpty()) {
            filteredOffers = this.removeOutOfDateOffers(offers);
            filteredOffers = this.removeInvalidCustomerOffers(filteredOffers, customer);
        }
        return filteredOffers;
    }

    protected List<Offer> removeOutOfDateOffers(List<Offer> offers) {
        Date now = SystemTime.asDate();
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (offer.getStartDate() == null || offer.getStartDate().after(now)) {
                offersToRemove.add(offer);
                continue;
            }
            if (offer.getEndDate() == null || !offer.getEndDate().before(now)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected List<Offer> removeInvalidCustomerOffers(List<Offer> offers, Customer customer) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToCustomer(offer, customer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToCustomer(Offer offer, Customer customer) {
        boolean appliesToCustomer = false;
        if (offer.getAppliesToCustomerRules() != null && offer.getAppliesToCustomerRules().length() != 0) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("customer", customer);
            Boolean expressionOutcome = this.executeExpression(offer.getAppliesToCustomerRules(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToCustomer = true;
            }
        } else {
            appliesToCustomer = true;
        }
        return appliesToCustomer;
    }

    protected boolean applyAllItemOffers(List<CandidateItemOffer> itemOffers, List<DiscreteOrderItem> discreteOrderItems) {
        boolean itemOffersApplied = false;
        int appliedItemOffersCount = 0;
        for (CandidateItemOffer itemOffer : itemOffers) {
            OrderItem orderItem = itemOffer.getOrderItem();
            if (orderItem.isNotCombinableOfferApplied() || (!itemOffer.getOffer().isCombinableWithOtherOffers() || !itemOffer.getOffer().isStackable()) && orderItem.isHasOrderItemAdjustments()) continue;
            this.applyOrderItemOffer(itemOffer);
            if (!itemOffer.getOffer().isCombinableWithOtherOffers()) {
                Money itemPrice = itemOffer.getOrderItem().getRetailPrice();
                if (itemOffer.getOrderItem().getSalePrice() != null) {
                    itemPrice = itemOffer.getOrderItem().getSalePrice();
                }
                if (itemOffer.getOrderItem().getAdjustmentPrice().greaterThanOrEqual(itemPrice)) {
                    itemOffer.getOrderItem().removeAllAdjustments();
                    --appliedItemOffersCount;
                }
            }
            ++appliedItemOffersCount;
        }
        if (appliedItemOffersCount > 0) {
            for (DiscreteOrderItem discreteOrderItem : discreteOrderItems) {
                if (discreteOrderItem.getAdjustmentPrice() == null) continue;
                Money itemPrice = discreteOrderItem.getRetailPrice();
                if (discreteOrderItem.getSalePrice() != null) {
                    itemPrice = discreteOrderItem.getSalePrice();
                }
                if (!discreteOrderItem.getAdjustmentPrice().greaterThanOrEqual(itemPrice)) continue;
                int offersRemoved = discreteOrderItem.removeAllAdjustments();
                appliedItemOffersCount -= offersRemoved;
            }
        }
        if (appliedItemOffersCount > 0) {
            itemOffersApplied = true;
        }
        return itemOffersApplied;
    }

    protected void applyOrderItemOffer(CandidateItemOffer itemOffer) {
        OrderItemAdjustment itemAdjustment = this.offerDao.createOrderItemAdjustment();
        itemAdjustment.init(itemOffer.getOrderItem(), itemOffer.getOffer(), itemOffer.getOffer().getName());
        itemOffer.getOrderItem().addOrderItemAdjustment(itemAdjustment);
    }

    protected boolean applyAllOrderOffers(List<CandidateOrderOffer> orderOffers, Order order) {
        boolean orderOffersApplied = false;
        for (CandidateOrderOffer orderOffer : orderOffers) {
            if (!orderOffer.getOffer().isStackable() && order.isHasOrderAdjustments()) continue;
            this.applyOrderOffer(orderOffer);
            orderOffersApplied = true;
            if (orderOffer.getOffer().isCombinableWithOtherOffers()) continue;
            if (order.getAdjustmentPrice().greaterThanOrEqual(order.calculateOrderItemsCurrentPrice())) {
                order.removeAllOrderAdjustments();
                orderOffersApplied = false;
                continue;
            }
            order.removeAllItemAdjustments();
            break;
        }
        return orderOffersApplied;
    }

    protected void applyOrderOffer(CandidateOrderOffer orderOffer) {
        OrderAdjustment orderAdjustment = this.offerDao.createOrderAdjustment();
        orderAdjustment.init(orderOffer.getOrder(), orderOffer.getOffer(), orderOffer.getOffer().getName());
        orderOffer.getOrder().addOrderAdjustments(orderAdjustment);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, Order order) {
        return this.couldOfferApplyToOrder(offer, order, null, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, Order order, DiscreteOrderItem discreteOrderItem) {
        return this.couldOfferApplyToOrder(offer, order, discreteOrderItem, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, Order order, FulfillmentGroup fulfillmentGroup) {
        return this.couldOfferApplyToOrder(offer, order, null, fulfillmentGroup);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, Order order, DiscreteOrderItem discreteOrderItem, FulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        if (offer.getAppliesToOrderRules() != null && offer.getAppliesToOrderRules().length() != 0) {
            Boolean expressionOutcome;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("order", order);
            vars.put("offer", offer);
            if (fulfillmentGroup != null) {
                vars.put("fulfillmentGroup", fulfillmentGroup);
            }
            if (discreteOrderItem != null) {
                vars.put("discreteOrderItem", discreteOrderItem);
            }
            if ((expressionOutcome = this.executeExpression(offer.getAppliesToOrderRules(), vars)) != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected Boolean executeExpression(String expression, Map<String, Object> vars) {
        Serializable exp = (Serializable)expressionCache.get((Object)expression);
        if (exp == null) {
            ParserContext context = new ParserContext();
            context.addImport("OfferType", OfferType.class);
            context.addImport("FulfillmentGroupType", FulfillmentGroupType.class);
            exp = MVEL.compileExpression((String)expression.toString(), (ParserContext)context);
        }
        expressionCache.put((Object)expression, (Object)exp);
        return (Boolean)MVEL.executeExpression((Object)exp, vars);
    }

    @Override
    public void applyFulfillmentGroupsOffers(List<FulfillmentGroup> fulfillmentGroups) {
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            this.applyFulfillmentGroupOffers(fulfillmentGroup);
        }
    }

    @Override
    public void applyFulfillmentGroupOffers(FulfillmentGroup fulfillmentGroup) {
        List<CandidateFulfillmentGroupOffer> qualifiedFulfillmentGroupOffers = fulfillmentGroup.getCandidateFulfillmentGroupOffers();
        if (qualifiedFulfillmentGroupOffers.size() > 0) {
            Collections.sort(qualifiedFulfillmentGroupOffers, new BeanComparator("discountedPrice"));
            Collections.sort(qualifiedFulfillmentGroupOffers, new BeanComparator("priority"));
            this.applyAllFulfillmentGroupOffers(qualifiedFulfillmentGroupOffers, fulfillmentGroup);
        }
        if (fulfillmentGroup.getAdjustmentPrice() != null) {
            fulfillmentGroup.setShippingPrice(fulfillmentGroup.getAdjustmentPrice());
        } else if (fulfillmentGroup.getSaleShippingPrice() != null) {
            fulfillmentGroup.setShippingPrice(fulfillmentGroup.getSaleShippingPrice());
        } else {
            fulfillmentGroup.setShippingPrice(fulfillmentGroup.getRetailShippingPrice());
        }
    }

    protected void applyAllFulfillmentGroupOffers(List<CandidateFulfillmentGroupOffer> fulfillmentGroupOffers, FulfillmentGroup fulfillmentGroup) {
        for (CandidateFulfillmentGroupOffer fulfillmentGroupOffer : fulfillmentGroupOffers) {
            if (!fulfillmentGroupOffer.getOffer().isStackable() && fulfillmentGroup.getFulfillmentGroupAdjustments().size() != 0) continue;
            this.applyFulfillmentGroupOffer(fulfillmentGroupOffer);
            if (fulfillmentGroupOffer.getOffer().isCombinableWithOtherOffers()) continue;
            break;
        }
    }

    protected void applyFulfillmentGroupOffer(CandidateFulfillmentGroupOffer fulfillmentGroupOffer) {
        FulfillmentGroupAdjustment fulfillmentGroupAdjustment = this.offerDao.createFulfillmentGroupAdjustment();
        fulfillmentGroupAdjustment.init(fulfillmentGroupOffer.getFulfillmentGroup(), fulfillmentGroupOffer.getOffer(), fulfillmentGroupOffer.getOffer().getName());
        fulfillmentGroupOffer.getFulfillmentGroup().addFulfillmentGroupAdjustment(fulfillmentGroupAdjustment);
    }

    @Override
    public OfferCode lookupOfferCodeByCode(String code) {
        return this.offerCodeDao.readOfferCodeByCode(code);
    }
}

