/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.domain.OfferImpl;
import org.broadleafcommerce.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.order.domain.OrderItem;
import org.broadleafcommerce.order.domain.OrderItemImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM_ADJUSTMENT")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class OrderItemAdjustmentImpl
implements OrderItemAdjustment {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemAdjustmentId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OrderItemAdjustmentId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="OrderItemAdjustmentImpl", allocationSize=50)
    @Column(name="ORDER_ITEM_ADJUSTMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    protected Offer offer;
    @Column(name="ADJUSTMENT_REASON", nullable=false)
    protected String reason;
    @Column(name="ADJUSTMENT_VALUE", nullable=false)
    protected BigDecimal value;

    @Override
    public void init(OrderItem orderItem, Offer offer, String reason) {
        this.orderItem = orderItem;
        this.offer = offer;
        this.reason = reason;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public Money getValue() {
        if (this.value == null) {
            this.computeAdjustmentValue();
        }
        return this.value == null ? null : new Money(this.value);
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.offer != null && this.orderItem != null) {
            Money adjustmentPrice = this.orderItem.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.offer.getApplyDiscountToSalePrice() && this.orderItem.getSalePrice() != null ? this.orderItem.getSalePrice() : this.orderItem.getRetailPrice();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.value = this.offer.getValue().getAmount();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                this.value = adjustmentPrice.subtract(this.offer.getValue()).getAmount();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                BigDecimal percentageOff = this.offer.getValue().getAmount().divide(new BigDecimal("100"));
                this.value = adjustmentPrice.multiply(percentageOff).getAmount();
            }
            if (adjustmentPrice.lessThan(this.value)) {
                this.value = adjustmentPrice.getAmount();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemAdjustmentImpl other = (OrderItemAdjustmentImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

