/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.offer.service.type.OfferType;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="BLC_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class OfferImpl
implements Offer {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OfferId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="OfferImpl", allocationSize=50)
    @Column(name="OFFER_ID")
    protected Long id;
    @Column(name="OFFER_NAME", nullable=false)
    protected String name;
    @Column(name="OFFER_DESCRIPTION")
    protected String description;
    @Column(name="OFFER_TYPE", nullable=false)
    protected String type;
    @Column(name="OFFER_DISCOUNT_TYPE")
    protected String discountType;
    @Column(name="OFFER_VALUE", nullable=false)
    protected BigDecimal value;
    @Column(name="OFFER_PRIORITY")
    protected int priority;
    @Column(name="START_DATE")
    protected Date startDate;
    @Column(name="END_DATE")
    protected Date endDate;
    @Column(name="STACKABLE")
    protected boolean stackable;
    @Column(name="TARGET_SYSTEM")
    protected String targetSystem;
    @Column(name="APPLY_TO_SALE_PRICE")
    protected boolean applyToSalePrice;
    @Column(name="APPLIES_TO_RULES")
    protected String appliesToOrderRules;
    @Column(name="APPLIES_WHEN_RULES")
    protected String appliesToCustomerRules;
    @Column(name="APPLY_OFFER_TO_MARKED_ITEMS")
    protected boolean applyDiscountToMarkedItems;
    @Column(name="COMBINABLE_WITH_OTHER_OFFERS")
    protected boolean combinableWithOtherOffers;
    @Column(name="OFFER_DELIVERY_TYPE", nullable=false)
    protected String deliveryType;
    @Column(name="MAX_USES")
    protected int maxUses;
    @Column(name="USES")
    protected int uses;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OfferType getType() {
        return this.type == null ? null : OfferType.getInstance(this.type);
    }

    @Override
    public void setType(OfferType type) {
        this.type = type.getType();
    }

    @Override
    public OfferDiscountType getDiscountType() {
        return this.discountType == null ? null : OfferDiscountType.getInstance(this.discountType);
    }

    @Override
    public void setDiscountType(OfferDiscountType discountType) {
        this.discountType = discountType.getType();
    }

    @Override
    public Money getValue() {
        return this.value == null ? null : new Money(this.value);
    }

    @Override
    public void setValue(Money value) {
        this.value = Money.toAmount((Money)value);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean isStackable() {
        return this.stackable;
    }

    @Override
    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    @Override
    public String getTargetSystem() {
        return this.targetSystem;
    }

    @Override
    public void setTargetSystem(String targetSystem) {
        this.targetSystem = targetSystem;
    }

    @Override
    public boolean getApplyDiscountToSalePrice() {
        return this.applyToSalePrice;
    }

    @Override
    public void setApplyDiscountToSalePrice(boolean applyToSalePrice) {
        this.applyToSalePrice = applyToSalePrice;
    }

    @Override
    public String getAppliesToOrderRules() {
        return this.appliesToOrderRules;
    }

    @Override
    public void setAppliesToOrderRules(String appliesToOrderRules) {
        this.appliesToOrderRules = appliesToOrderRules;
    }

    @Override
    public String getAppliesToCustomerRules() {
        return this.appliesToCustomerRules;
    }

    @Override
    public void setAppliesToCustomerRules(String appliesToCustomerRules) {
        this.appliesToCustomerRules = appliesToCustomerRules;
    }

    @Override
    public boolean isApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Override
    public void setApplyDiscountToMarkedItems(boolean applyDiscountToMarkedItems) {
        this.applyDiscountToMarkedItems = applyDiscountToMarkedItems;
    }

    @Override
    public boolean isCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public void setCombinableWithOtherOffers(boolean combinableWithOtherOffers) {
        this.combinableWithOtherOffers = combinableWithOtherOffers;
    }

    @Override
    public OfferDeliveryType getDeliveryType() {
        return this.deliveryType == null ? null : OfferDeliveryType.getInstance(this.deliveryType);
    }

    @Override
    public void setDeliveryType(OfferDeliveryType deliveryType) {
        this.deliveryType = deliveryType.getType();
    }

    @Override
    public int getMaxUses() {
        return this.maxUses;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public void setUses(int uses) {
        this.uses = uses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appliesToCustomerRules == null ? 0 : this.appliesToCustomerRules.hashCode());
        result = 31 * result + (this.appliesToOrderRules == null ? 0 : this.appliesToOrderRules.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferImpl other = (OfferImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.appliesToCustomerRules == null ? other.appliesToCustomerRules != null : !this.appliesToCustomerRules.equals(other.appliesToCustomerRules)) {
            return false;
        }
        if (this.appliesToOrderRules == null ? other.appliesToOrderRules != null : !this.appliesToOrderRules.equals(other.appliesToOrderRules)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

