/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.domain.OfferImpl;
import org.broadleafcommerce.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="BLC_FG_ADJUSTMENT")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupAdjustmentImpl
implements FulfillmentGroupAdjustment {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FGAdjustmentId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FGAdjustmentId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupAdjustmentImpl", allocationSize=50)
    @Column(name="FG_ADJUSTMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    protected FulfillmentGroup fulfillmentGroup;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    protected Offer offer;
    @Column(name="ADJUSTMENT_REASON", nullable=false)
    protected String reason;
    @Column(name="ADJUSTMENT_VALUE", nullable=false)
    protected BigDecimal value;

    @Override
    public void init(FulfillmentGroup fulfillmentGroup, Offer offer, String reason) {
        this.fulfillmentGroup = fulfillmentGroup;
        this.offer = offer;
        this.reason = reason;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public Money getValue() {
        if (this.value == null) {
            this.computeAdjustmentValue();
        }
        return this.value == null ? null : new Money(this.value);
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.offer != null && this.fulfillmentGroup != null) {
            Money adjustmentPrice = this.fulfillmentGroup.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.offer.getApplyDiscountToSalePrice() && this.fulfillmentGroup.getSaleShippingPrice() != null ? this.fulfillmentGroup.getSaleShippingPrice() : this.fulfillmentGroup.getRetailShippingPrice();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.value = this.offer.getValue().getAmount();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                this.value = adjustmentPrice.subtract(this.offer.getValue()).getAmount();
            }
            if (this.offer.getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                this.value = adjustmentPrice.multiply(this.offer.getValue().divide(new BigDecimal("100")).getAmount()).getAmount();
            }
            if (adjustmentPrice.lessThan(this.value)) {
                this.value = adjustmentPrice.getAmount();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fulfillmentGroup == null ? 0 : this.fulfillmentGroup.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupAdjustmentImpl other = (FulfillmentGroupAdjustmentImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.fulfillmentGroup == null ? other.fulfillmentGroup != null : !this.fulfillmentGroup.equals(other.fulfillmentGroup)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

