/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.offer.domain.Offer;
import org.broadleafcommerce.offer.domain.OfferImpl;
import org.broadleafcommerce.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.domain.OrderImpl;
import org.broadleafcommerce.util.money.Money;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="BLC_CANDIDATE_ORDER_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class CandidateOrderOfferImpl
implements CandidateOrderOffer {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CandidateOrderOfferId", strategy=GenerationType.TABLE)
    @TableGenerator(name="CandidateOrderOfferId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="CandidateOrderOfferImpl", allocationSize=50)
    @Column(name="CANDIDATE_ORDER_OFFER_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    protected Order order;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    protected Offer offer;
    @Column(name="DISCOUNTED_PRICE")
    protected BigDecimal discountedPrice;
    @Transient
    private BigDecimal discountAmount;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public int getPriority() {
        return this.offer.getPriority();
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
        this.discountedPrice = null;
    }

    @Override
    public Money getDiscountedPrice() {
        if (this.discountedPrice == null) {
            this.computeDiscountedPriceAndAmount();
        }
        return this.discountedPrice == null ? null : new Money(this.discountedPrice);
    }

    @Override
    public Money getDiscountAmount() {
        if (this.discountAmount == null) {
            this.computeDiscountedPriceAndAmount();
        }
        return this.discountAmount == null ? null : new Money(this.discountAmount);
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
        this.discountedPrice = null;
    }

    protected void computeDiscountedPriceAndAmount() {
        if (this.offer != null && this.order != null && this.order.getSubTotal() != null) {
            Money priceToUse = this.order.getSubTotal();
            Money discountAmount = new Money(0);
            if (this.offer.getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                discountAmount = this.offer.getValue();
            } else if (this.offer.getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                discountAmount = priceToUse.subtract(this.offer.getValue());
            } else if (this.offer.getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                discountAmount = priceToUse.multiply(this.offer.getValue().divide(new BigDecimal("100")).getAmount());
            }
            if (discountAmount.greaterThan(priceToUse)) {
                discountAmount = priceToUse;
            }
            priceToUse = priceToUse.subtract(discountAmount);
            this.discountedPrice = priceToUse.getAmount();
            this.discountAmount = discountAmount.getAmount();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discountedPrice == null ? 0 : this.discountedPrice.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CandidateOrderOfferImpl other = (CandidateOrderOfferImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.discountedPrice == null ? other.discountedPrice != null : !this.discountedPrice.equals(other.discountedPrice)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        return !(this.order == null ? other.order != null : !this.order.equals(other.order));
    }
}

