/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.offer.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.offer.domain.CustomerOffer;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerOfferDao")
public class CustomerOfferDaoImpl
implements CustomerOfferDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public CustomerOffer create() {
        return (CustomerOffer)this.entityConfiguration.createEntityInstance(CustomerOffer.class.getName());
    }

    @Override
    public void delete(CustomerOffer customerOffer) {
        this.em.remove((Object)customerOffer);
    }

    @Override
    public CustomerOffer save(CustomerOffer customerOffer) {
        if (customerOffer.getId() == null) {
            this.em.persist((Object)customerOffer);
        } else {
            customerOffer = (CustomerOffer)this.em.merge((Object)customerOffer);
        }
        return customerOffer;
    }

    @Override
    public CustomerOffer readCustomerOfferById(Long customerOfferId) {
        return (CustomerOffer)this.em.find(this.entityConfiguration.lookupEntityClass(CustomerOffer.class.getName()), (Object)customerOfferId);
    }

    @Override
    public List<CustomerOffer> readCustomerOffersByCustomer(Customer customer) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_OFFER_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customer.getId());
        List result = query.getResultList();
        return result;
    }
}

