/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.marketing.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.marketing.dao.TargetContentDao;
import org.broadleafcommerce.marketing.domain.TargetContent;
import org.broadleafcommerce.marketing.service.TargetContentService;
import org.springframework.stereotype.Service;

@Service(value="blTargetContentService")
public class TargetContentServiceImpl
implements TargetContentService {
    @Resource(name="blTargetContentDao")
    protected TargetContentDao targetContentDao;

    @Override
    public TargetContent findTargetContentById(Long targetContentId) {
        return this.targetContentDao.readTargetContentById(targetContentId);
    }

    @Override
    public List<TargetContent> findTargetContents() {
        return this.targetContentDao.readTargetContents();
    }

    @Override
    public List<TargetContent> findTargetContentsByNameType(String name, String type) {
        return this.targetContentDao.readCurrentTargetContentByNameType(name, type);
    }

    @Override
    public List<TargetContent> findTargetContentsByPriority(int priority) {
        return this.targetContentDao.readCurrentTargetContentsByPriority(priority);
    }

    @Override
    public void removeTargetContent(Long targetContentId) {
        this.targetContentDao.delete(targetContentId);
    }

    @Override
    public TargetContent updateTargetContent(TargetContent targetContent) {
        return this.targetContentDao.save(targetContent);
    }
}

