/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.inventory.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.inventory.dao.AvailabilityDao;
import org.broadleafcommerce.inventory.domain.SkuAvailability;
import org.broadleafcommerce.inventory.service.AvailabilityService;
import org.springframework.stereotype.Service;

@Service(value="blAvailabilityService")
public class AvailabilityServiceImpl
implements AvailabilityService {
    @Resource(name="blAvailabilityDao")
    protected AvailabilityDao availabilityDao;

    @Override
    public SkuAvailability lookupSKUAvailability(Long skuId, boolean realTime) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        List<SkuAvailability> skuAvailbilityList = this.availabilityDao.readSKUAvailability(skuIds, realTime);
        if (skuAvailbilityList != null && skuAvailbilityList.size() >= 1) {
            return skuAvailbilityList.get(0);
        }
        return null;
    }

    @Override
    public SkuAvailability lookupSKUAvailabilityForLocation(Long skuId, Long locationId, boolean realTime) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        List<SkuAvailability> skuAvailbilityList = this.availabilityDao.readSKUAvailabilityForLocation(skuIds, locationId, realTime);
        if (skuAvailbilityList != null && skuAvailbilityList.size() >= 1) {
            return skuAvailbilityList.get(0);
        }
        return null;
    }

    @Override
    public List<SkuAvailability> lookupSKUAvailability(List<Long> skuIds, boolean realTime) {
        return this.availabilityDao.readSKUAvailability(skuIds, realTime);
    }

    @Override
    public List<SkuAvailability> lookupSKUAvailabilityForLocation(List<Long> skuIds, Long locationId, boolean realTime) {
        return this.availabilityDao.readSKUAvailabilityForLocation(skuIds, locationId, realTime);
    }
}

