/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.inventory.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.inventory.domain.SkuAvailability;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_AVAILABILITY")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class SkuAvailabilityImpl
implements SkuAvailability {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuAvailabilityId", strategy=GenerationType.TABLE)
    @TableGenerator(name="SkuAvailabilityId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="SkuAvailabilityImpl", allocationSize=50)
    @Column(name="SKU_AVAILABILITY_ID")
    protected Long id;
    @Column(name="SKU_ID")
    protected Long skuId;
    @Column(name="LOCATION_ID")
    protected Long locationId;
    @Column(name="QTY_ON_HAND")
    protected Integer quantityOnHand;
    @Column(name="RESERVE_QTY")
    protected Integer reserveQuantity;
    @Column(name="AVAILABILITY_STATUS")
    protected String availabilityStatus;
    @Column(name="AVAILABILITY_DATE")
    protected Date availabilityDate;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getLocationId() {
        return this.locationId;
    }

    @Override
    public Integer getQuantityOnHand() {
        return this.quantityOnHand;
    }

    @Override
    public Long getSkuId() {
        return this.skuId;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    @Override
    public void setQuantityOnHand(Integer qoh) {
        this.quantityOnHand = qoh;
    }

    @Override
    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @Override
    public Date getAvailabilityDate() {
        return this.availabilityDate;
    }

    @Override
    public void setAvailabilityDate(Date availabilityDate) {
        this.availabilityDate = availabilityDate;
    }

    @Override
    public String getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    @Override
    public void setAvailabilityStatus(String status) {
        this.availabilityStatus = status;
    }

    @Override
    public Integer getReserveQuantity() {
        return this.reserveQuantity;
    }

    @Override
    public void setReserveQuantity(Integer reserveQuantity) {
        this.reserveQuantity = reserveQuantity;
    }

    @Override
    public Integer getAvailableQuantity() {
        if (this.getQuantityOnHand() == null || this.getReserveQuantity() == null) {
            return this.getQuantityOnHand();
        }
        return this.getQuantityOnHand() - this.getReserveQuantity();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locationId == null ? 0 : this.locationId.hashCode());
        result = 31 * result + (this.skuId == null ? 0 : this.skuId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkuAvailabilityImpl other = (SkuAvailabilityImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.locationId == null ? other.locationId != null : !this.locationId.equals(other.locationId)) {
            return false;
        }
        return !(this.skuId == null ? other.skuId != null : !this.skuId.equals(other.skuId));
    }
}

