/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.inventory.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.inventory.dao.AvailabilityDao;
import org.broadleafcommerce.inventory.domain.SkuAvailability;
import org.springframework.stereotype.Repository;

@Repository(value="blAvailabilityDao")
public class AvailabilityDaoImpl
implements AvailabilityDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    protected String queryCacheableKey = "org.hibernate.cacheable";
    private static final int inBatchSize = 300;

    @Override
    public List<SkuAvailability> readSKUAvailability(List<Long> skuIds, boolean realTime) {
        ArrayList<SkuAvailability> skuAvailabilities = new ArrayList<SkuAvailability>();
        for (int start = 0; start < skuIds.size(); start += 300) {
            List<Long> batchSkuIds = skuIds.subList(start, skuIds.size() < 300 ? skuIds.size() : 300);
            Query query = this.em.createNamedQuery("BC_READ_SKU_AVAILABILITIES_BY_SKU_IDS");
            if (!realTime) {
                query.setHint(this.getQueryCacheableKey(), (Object)true);
            }
            query.setParameter("skuIds", batchSkuIds);
            skuAvailabilities.addAll(query.getResultList());
        }
        return skuAvailabilities;
    }

    @Override
    public List<SkuAvailability> readSKUAvailabilityForLocation(List<Long> skuIds, Long locationId, boolean realTime) {
        ArrayList<SkuAvailability> skuAvailabilities = new ArrayList<SkuAvailability>();
        for (int start = 0; start < skuIds.size(); start += 300) {
            List<Long> batchSkuIds = skuIds.subList(start, skuIds.size() < 300 ? skuIds.size() : 300);
            Query query = this.em.createNamedQuery("BC_READ_SKU_AVAILABILITIES_BY_LOCATION_ID_AND_SKU_IDS");
            if (!realTime) {
                query.setHint(this.getQueryCacheableKey(), (Object)true);
            }
            query.setParameter("skuIds", batchSkuIds);
            query.setParameter("locationId", (Object)locationId);
            skuAvailabilities.addAll(query.getResultList());
        }
        return skuAvailabilities;
    }

    @Override
    public void save(SkuAvailability skuAvailability) {
        this.em.persist((Object)skuAvailability);
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }
}

