/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.checkout.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.checkout.service.CheckoutService;
import org.broadleafcommerce.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.order.service.CartService;
import org.broadleafcommerce.payment.domain.PaymentInfo;
import org.broadleafcommerce.payment.domain.Referenced;
import org.broadleafcommerce.pricing.service.exception.PricingException;
import org.broadleafcommerce.time.SystemTime;
import org.broadleafcommerce.workflow.SequenceProcessor;
import org.broadleafcommerce.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blCheckoutService")
public class CheckoutServiceImpl
implements CheckoutService {
    @Resource(name="blCheckoutWorkflow")
    protected SequenceProcessor checkoutWorkflow;
    @Resource(name="blCartService")
    protected CartService cartService;

    @Override
    public CheckoutResponse performCheckout(Order order, Map<PaymentInfo, Referenced> payments) throws CheckoutException {
        for (PaymentInfo info : payments.keySet()) {
            if (info.getReferenceNumber() != null) continue;
            throw new CheckoutException("PaymentInfo reference number cannot be null", null);
        }
        for (Referenced referenced : payments.values()) {
            if (referenced.getReferenceNumber() != null) continue;
            throw new CheckoutException("Referenced reference number cannot be null", null);
        }
        CheckoutSeed seed = null;
        try {
            order.setSubmitDate(SystemTime.asDate());
            order = this.cartService.save(order, false);
            seed = new CheckoutSeed(order, payments, new HashMap<String, Object>());
            this.checkoutWorkflow.doActivities(seed);
            return seed;
        }
        catch (PricingException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e, seed);
        }
        catch (WorkflowException e) {
            Throwable cause = e;
            while (e.getCause() != null && !cause.equals(e.getCause())) {
                cause = e.getCause();
            }
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), cause, seed);
        }
    }

    @Override
    public CheckoutResponse performCheckout(Order order) throws CheckoutException {
        return this.performCheckout(order, null);
    }
}

