/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.catalog.dao.CategoryDao;
import org.broadleafcommerce.catalog.dao.ProductDao;
import org.broadleafcommerce.catalog.dao.SkuDao;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.catalog.service.CatalogService;
import org.springframework.stereotype.Service;

@Service(value="blCatalogService")
public class CatalogServiceImpl
implements CatalogService {
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;

    @Override
    public Product findProductById(Long productId) {
        return this.productDao.readProductById(productId);
    }

    @Override
    public List<Product> findProductsByName(String searchName) {
        return this.productDao.readProductsByName(searchName);
    }

    @Override
    public List<Product> findActiveProductsByCategory(Category category, Date currentDate) {
        return this.productDao.readActiveProductsByCategory(category.getId(), currentDate);
    }

    @Override
    public Product saveProduct(Product product) {
        return this.productDao.save(product);
    }

    @Override
    public Category findCategoryById(Long categoryId) {
        return this.categoryDao.readCategoryById(categoryId);
    }

    @Override
    public Category findCategoryByName(String categoryName) {
        return this.categoryDao.readCategoryByName(categoryName);
    }

    @Override
    public Category saveCategory(Category category) {
        return this.categoryDao.save(category);
    }

    @Override
    public List<Category> findAllCategories() {
        return this.categoryDao.readAllCategories();
    }

    @Override
    public List<Product> findAllProducts() {
        return this.categoryDao.readAllProducts();
    }

    @Override
    public List<Sku> findAllSkus() {
        return this.skuDao.readAllSkus();
    }

    @Override
    public Sku findSkuById(Long skuId) {
        return this.skuDao.readSkuById(skuId);
    }

    @Override
    public Sku saveSku(Sku sku) {
        return this.skuDao.save(sku);
    }

    @Override
    public List<Sku> findSkusByIds(List<Long> ids) {
        return this.skuDao.readSkusById(ids);
    }

    public void setProductDao(ProductDao productDao) {
        this.productDao = productDao;
    }

    public void setSkuDao(SkuDao skuDao) {
        this.skuDao = skuDao;
    }

    @Override
    public List<Product> findProductsForCategory(Category category) {
        return null;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    @Override
    public Map<String, List<Category>> getChildCategoryURLMapByCategoryId(Long categoryId) {
        Category category = this.findCategoryById(categoryId);
        if (category != null) {
            return category.getChildCategoryURLMap();
        }
        return null;
    }
}

