/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.domain.ProductImpl;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.util.DateUtil;
import org.broadleafcommerce.util.money.Money;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Searchable
public class SkuImpl
implements Sku {
    private static final Log LOG = LogFactory.getLog(SkuImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuId", strategy=GenerationType.TABLE)
    @TableGenerator(name="SkuId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="SkuImpl", allocationSize=50)
    @Column(name="SKU_ID")
    @SearchableId
    protected Long id;
    @Column(name="SALE_PRICE")
    protected BigDecimal salePrice;
    @Column(name="RETAIL_PRICE", nullable=false)
    protected BigDecimal retailPrice;
    @Column(name="NAME", nullable=false)
    @SearchableProperty
    protected String name;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="LONG_DESCRIPTION")
    protected String longDescription;
    @Column(name="TAXABLE_FLAG")
    protected Character taxable;
    @Column(name="DISCOUNTABLE_FLAG")
    protected Character discountable;
    @Column(name="AVAILABLE_FLAG")
    protected Character available;
    @Column(name="ACTIVE_START_DATE")
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    protected Date activeEndDate;
    @CollectionOfElements
    @JoinTable(name="BLC_SKU_IMAGE", joinColumns={@JoinColumn(name="SKU_ID")})
    @MapKey(columns={@Column(name="NAME", length=5)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected Map<String, String> skuImages = new HashMap<String, String>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=ProductImpl.class)
    @JoinTable(name="BLC_PRODUCT_SKU_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)}, inverseJoinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID", nullable=true)})
    protected List<Product> allParentProducts = new ArrayList<Product>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Money getSalePrice() {
        return this.salePrice == null ? null : new Money(this.salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getRetailPrice() {
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getListPrice() {
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setListPrice(Money listPrice) {
        this.retailPrice = Money.toAmount((Money)listPrice);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Boolean isTaxable() {
        if (this.taxable == null) {
            return null;
        }
        return this.taxable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getTaxable() {
        return this.isTaxable();
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable == null ? null : Character.valueOf(taxable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isDiscountable() {
        if (this.discountable == null) {
            return null;
        }
        return this.discountable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getDiscountable() {
        return this.isDiscountable();
    }

    @Override
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable == null ? null : Character.valueOf(discountable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isAvailable() {
        if (this.available == null) {
            return null;
        }
        return this.available.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setAvailable(Boolean available) {
        this.available = available == null ? null : Character.valueOf(available != false ? (char)'Y' : 'N');
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
            LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false);
    }

    @Override
    public boolean isActive(Product product, Category category) {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
            } else if (!product.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to product being inactive"));
            } else if (!category.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to category being inactive"));
            }
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false) || !product.isActive() || !category.isActive();
    }

    @Override
    public Map<String, String> getSkuImages() {
        return this.skuImages;
    }

    @Override
    public String getSkuImage(String imageKey) {
        return this.skuImages.get(imageKey);
    }

    @Override
    public void setSkuImages(Map<String, String> skuImages) {
        this.skuImages = skuImages;
    }

    @Override
    public List<Product> getAllParentProducts() {
        return this.allParentProducts;
    }

    @Override
    public void setAllParentProducts(List<Product> allParentProducts) {
        this.allParentProducts = allParentProducts;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkuImpl other = (SkuImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

