/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.CategoryImpl;
import org.broadleafcommerce.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.domain.ProductDimension;
import org.broadleafcommerce.catalog.domain.ProductWeight;
import org.broadleafcommerce.catalog.domain.RelatedProduct;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.catalog.domain.SkuImpl;
import org.broadleafcommerce.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.util.DateUtil;
import org.broadleafcommerce.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.vendor.service.type.ContainerSizeType;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.compass.annotations.SupportUnmarshall;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Searchable(alias="product", supportUnmarshall=SupportUnmarshall.FALSE)
public class ProductImpl
implements Product {
    private static final Log LOG = LogFactory.getLog(ProductImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductId", strategy=GenerationType.TABLE)
    @TableGenerator(name="ProductId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="ProductImpl", allocationSize=50)
    @Column(name="PRODUCT_ID")
    @SearchableId
    protected Long id;
    @Column(name="NAME", nullable=false)
    @SearchableProperty(name="productName")
    protected String name;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="LONG_DESCRIPTION")
    @SearchableProperty(name="productDescription")
    protected String longDescription;
    @Column(name="ACTIVE_START_DATE")
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    protected Date activeEndDate;
    @Column(name="MODEL")
    @SearchableProperty(name="productModel")
    protected String model;
    @Column(name="MANUFACTURE")
    @SearchableProperty(name="productManufacturer")
    protected String manufacturer;
    @Embedded
    protected ProductDimension dimension = new ProductDimension();
    @Embedded
    protected ProductWeight weight = new ProductWeight();
    @OneToMany(mappedBy="product", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="product", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OrderBy(value="sequence")
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class)
    @JoinTable(name="BLC_PRODUCT_SKU_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected List<Sku> allSkus = new ArrayList<Sku>();
    @CollectionOfElements
    @JoinTable(name="BLC_PRODUCT_IMAGE", joinColumns={@JoinColumn(name="PRODUCT_ID")})
    @MapKey(columns={@Column(name="NAME", length=5)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected Map<String, String> productImages = new HashMap<String, String>();
    @OneToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_CATEGORY_ID")
    protected Category defaultCategory;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=CategoryImpl.class)
    @JoinTable(name="BLC_CATEGORY_PRODUCT_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", referencedColumnName="CATEGORY_ID", nullable=true)})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected List<Category> allParentCategories = new ArrayList<Category>();
    @Column(name="IS_FEATURED_PRODUCT", nullable=false)
    protected boolean isFeaturedProduct = false;
    @Column(name="IS_MACHINE_SORTABLE")
    protected boolean isMachineSortable = true;
    @Transient
    protected List<Sku> skus = new ArrayList<Sku>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
            LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false);
    }

    public List<Sku> getAllSkus() {
        return this.allSkus;
    }

    @Override
    public List<Sku> getSkus() {
        if (this.skus != null && this.skus.size() == 0) {
            List<Sku> allSkus = this.getAllSkus();
            for (Sku sku : allSkus) {
                if (!sku.isActive()) continue;
                this.skus.add(sku);
            }
        }
        return this.skus;
    }

    @Override
    public void setAllSkus(List<Sku> skus) {
        this.allSkus = skus;
        this.skus.clear();
    }

    @Override
    public Map<String, String> getProductImages() {
        return this.productImages;
    }

    @Override
    public String getProductImage(String imageKey) {
        return this.productImages.get(imageKey);
    }

    @Override
    public void setProductImages(Map<String, String> productImages) {
        this.productImages = productImages;
    }

    @Override
    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    public List<Category> getAllParentCategories() {
        return this.allParentCategories;
    }

    public void setAllParentCategories(List<Category> allParentCategories) {
        this.allParentCategories = allParentCategories;
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        return this.crossSaleProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts = crossSaleProducts;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public ProductDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(ProductDimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public BigDecimal getWidth() {
        return this.dimension.getWidth();
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.dimension.setWidth(width);
    }

    @Override
    public BigDecimal getHeight() {
        return this.dimension.getHeight();
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.dimension.setHeight(height);
    }

    @Override
    public BigDecimal getDepth() {
        return this.dimension.getDepth();
    }

    @Override
    public void setDepth(BigDecimal depth) {
        this.dimension.setDepth(depth);
    }

    @Override
    public void setGirth(BigDecimal girth) {
        this.dimension.setGirth(girth);
    }

    @Override
    public BigDecimal getGirth() {
        return this.dimension.getGirth();
    }

    @Override
    public ContainerSizeType getSize() {
        return this.dimension.getSize();
    }

    @Override
    public void setSize(ContainerSizeType size) {
        this.dimension.setSize(size);
    }

    @Override
    public ContainerShapeType getContainer() {
        return this.dimension.getContainer();
    }

    @Override
    public void setContainer(ContainerShapeType container) {
        this.dimension.setContainer(container);
    }

    @Override
    public String getDimensionString() {
        return this.dimension.getDimensionString();
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        return this.upSaleProducts;
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public boolean getIsFeaturedProduct() {
        return this.isFeaturedProduct;
    }

    @Override
    public void setFeaturedProduct(boolean isFeaturedProduct) {
        this.isFeaturedProduct = isFeaturedProduct;
    }

    @Override
    public boolean isMachineSortable() {
        return this.isMachineSortable;
    }

    @Override
    public void setMachineSortable(boolean isMachineSortable) {
        this.isMachineSortable = isMachineSortable;
    }

    @Override
    public ProductWeight getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(ProductWeight weight) {
        this.weight = weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.skus == null ? 0 : ((Object)this.skus).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductImpl other = (ProductImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.skus == null ? other.skus != null : !((Object)this.skus).equals(other.skus));
    }
}

