/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.broadleafcommerce.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.vendor.service.type.ContainerSizeType;

@Embeddable
public class ProductDimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="WIDTH")
    protected BigDecimal width;
    @Column(name="HEIGHT")
    protected BigDecimal height;
    @Column(name="DEPTH")
    protected BigDecimal depth;
    @Column(name="GIRTH")
    protected BigDecimal girth;
    @Column(name="CONTAINER_SIZE")
    protected String size;
    @Column(name="CONTAINER_SHAPE")
    protected String container;
    @Column(name="DIMENSION_UNIT_OF_MEASURE")
    protected String dimensionUnitOfMeasure;

    public DimensionUnitOfMeasureType getDimensionUnitOfMeasure() {
        return this.dimensionUnitOfMeasure == null ? null : DimensionUnitOfMeasureType.getInstance((String)this.dimensionUnitOfMeasure);
    }

    public void setDimensionUnitOfMeasure(DimensionUnitOfMeasureType dimensionUnitOfMeasure) {
        this.dimensionUnitOfMeasure = dimensionUnitOfMeasure.getType();
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getDepth() {
        return this.depth;
    }

    public void setDepth(BigDecimal depth) {
        this.depth = depth;
    }

    public String getDimensionString() {
        return this.height + "Hx" + this.width + "Wx" + this.depth + "D\"";
    }

    public BigDecimal getGirth() {
        return this.girth;
    }

    public void setGirth(BigDecimal girth) {
        this.girth = girth;
    }

    public ContainerSizeType getSize() {
        return this.size == null ? null : ContainerSizeType.getInstance((String)this.size);
    }

    public void setSize(ContainerSizeType size) {
        this.size = size.getType();
    }

    public ContainerShapeType getContainer() {
        return this.container == null ? null : ContainerShapeType.getInstance((String)this.container);
    }

    public void setContainer(ContainerShapeType container) {
        this.container = container.getType();
    }
}

