/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.catalog.domain.Category;
import org.broadleafcommerce.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.catalog.domain.FeaturedProductImpl;
import org.broadleafcommerce.util.DateUtil;
import org.broadleafcommerce.util.HydratedCache;
import org.broadleafcommerce.util.HydratedCacheManager;
import org.broadleafcommerce.util.UrlUtil;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.OrderBy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class CategoryImpl
implements Category {
    private static final Log LOG = LogFactory.getLog(CategoryImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CategoryId", strategy=GenerationType.TABLE)
    @TableGenerator(name="CategoryId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="CategoryImpl", allocationSize=50)
    @Column(name="CATEGORY_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="URL")
    protected String url;
    @Column(name="URL_KEY")
    protected String urlKey;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_PARENT_CATEGORY_ID")
    protected Category defaultParentCategory;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="ACTIVE_START_DATE")
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    protected Date activeEndDate;
    @Column(name="DISPLAY_TEMPLATE")
    protected String displayTemplate;
    @ManyToMany(targetEntity=CategoryImpl.class)
    @JoinTable(name="BLC_CATEGORY_XREF", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="SUB_CATEGORY_ID", referencedColumnName="CATEGORY_ID")})
    @OrderBy(clause="DISPLAY_ORDER")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected List<Category> allChildCategories = new ArrayList<Category>();
    @ManyToMany(targetEntity=CategoryImpl.class)
    @JoinTable(name="BLC_CATEGORY_XREF", joinColumns={@JoinColumn(name="SUB_CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", referencedColumnName="CATEGORY_ID", nullable=true)})
    @OrderBy(clause="DISPLAY_ORDER")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected List<Category> allParentCategories = new ArrayList<Category>();
    @CollectionOfElements
    @JoinTable(name="BLC_CATEGORY_IMAGE", joinColumns={@JoinColumn(name="CATEGORY_ID")})
    @MapKey(columns={@Column(name="NAME", length=5)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected Map<String, String> categoryImages = new HashMap<String, String>();
    @Column(name="LONG_DESCRIPTION")
    protected String longDescription;
    @OneToMany(mappedBy="category", targetEntity=FeaturedProductImpl.class, cascade={CascadeType.ALL})
    protected List<FeaturedProduct> featuredProducts = new ArrayList<FeaturedProduct>();
    @Transient
    protected List<Category> childCategories = new ArrayList<Category>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Category getDefaultParentCategory() {
        return this.defaultParentCategory;
    }

    @Override
    public void setDefaultParentCategory(Category defaultParentCategory) {
        this.defaultParentCategory = defaultParentCategory;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrlKey() {
        if ((this.urlKey == null || "".equals(this.urlKey)) && this.getName() != null) {
            return UrlUtil.generateUrlKey((String)this.getName());
        }
        return this.urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        return this.buildLink(null, this, false);
    }

    private String buildLink(String link, Category category, boolean ignoreTopLevel) {
        if (category == null || ignoreTopLevel && category.getDefaultParentCategory() == null) {
            return link;
        }
        link = link == null ? category.getUrlKey() : category.getUrlKey() + "/" + link;
        return this.buildLink(link, category.getDefaultParentCategory(), ignoreTopLevel);
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
            LOG.debug((Object)("category, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false);
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    @Override
    public List<Category> getChildCategories() {
        if (this.childCategories.size() == 0) {
            for (Category category : this.allChildCategories) {
                if (!category.isActive()) continue;
                this.childCategories.add(category);
            }
        }
        return this.childCategories;
    }

    @Override
    public boolean hasChildCategories() {
        return this.getChildCategories().size() > 0;
    }

    @Override
    public void setChildCategories(List<Category> allChildCategories) {
        this.allChildCategories = allChildCategories;
    }

    @Override
    public Map<String, String> getCategoryImages() {
        return this.categoryImages;
    }

    @Override
    public String getCategoryImage(String imageKey) {
        return this.categoryImages.get(imageKey);
    }

    @Override
    public void setCategoryImages(Map<String, String> categoryImages) {
        this.categoryImages = categoryImages;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Map<String, List<Category>> getChildCategoryURLMap() {
        Map<String, List<Category>> cachedChildCategoryUrlMap;
        HydratedCache hydratedCache = HydratedCacheManager.getInstance().getHydratedCache(CategoryImpl.class.getName());
        if (hydratedCache != null && (cachedChildCategoryUrlMap = (Map)hydratedCache.get((Object)("cachedChildCategoryUrlMap_" + this.getId()))) != null && !cachedChildCategoryUrlMap.isEmpty()) {
            return cachedChildCategoryUrlMap;
        }
        cachedChildCategoryUrlMap = new HashMap();
        HashMap<String, List<Category>> newMap = new HashMap<String, List<Category>>();
        this.fillInURLMapForCategory(newMap, this, "", new ArrayList<Category>());
        cachedChildCategoryUrlMap = newMap;
        if (hydratedCache != null) {
            hydratedCache.put((Object)("cachedChildCategoryUrlMap_" + this.getId()), cachedChildCategoryUrlMap);
        }
        return cachedChildCategoryUrlMap;
    }

    private void fillInURLMapForCategory(Map<String, List<Category>> categoryUrlMap, Category category, String startingPath, List<Category> startingCategoryList) {
        String currentPath = startingPath + "/" + category.getUrlKey();
        ArrayList<Category> newCategoryList = new ArrayList<Category>(startingCategoryList);
        newCategoryList.add(category);
        category.getCategoryImages().size();
        categoryUrlMap.put(currentPath, newCategoryList);
        for (Category currentCategory : category.getChildCategories()) {
            this.fillInURLMapForCategory(categoryUrlMap, currentCategory, currentPath, newCategoryList);
        }
    }

    public List<Category> getAllParentCategories() {
        return this.allParentCategories;
    }

    public void setAllParentCategories(List<Category> allParentCategories) {
        this.allParentCategories = allParentCategories;
    }

    @Override
    public List<FeaturedProduct> getFeaturedProducts() {
        return this.featuredProducts;
    }

    @Override
    public void setFeaturedProducts(List<FeaturedProduct> featuredProducts) {
        this.featuredProducts = featuredProducts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryImpl other = (CategoryImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

