/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.broadleafcommerce.catalog.domain.BasePrice;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.catalog.domain.SkuImpl;
import org.broadleafcommerce.common.domain.Auditable;
import org.broadleafcommerce.util.money.Money;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BASE_PRICE")
public class BasePriceImpl
implements BasePrice {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="BasePriceId", strategy=GenerationType.TABLE)
    @TableGenerator(name="BasePriceId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="BasePriceImpl", allocationSize=50)
    @Column(name="BASE_PRICE_ID")
    protected Long id;
    @Embedded
    protected Auditable auditable = new Auditable();
    @ManyToOne(targetEntity=SkuImpl.class)
    @JoinColumn(name="SKU_ID", nullable=false)
    protected Sku sku;
    @Column(name="AMOUNT", nullable=false)
    protected BigDecimal amount;
    @Column(name="START_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date startDate;
    @Column(name="END_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date endDate;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? null : new Money(this.amount);
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }

    @Override
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.auditable == null ? 0 : this.auditable.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.sku == null ? 0 : this.sku.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasePriceImpl other = (BasePriceImpl)obj;
        if (this.id == null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.auditable == null ? other.auditable != null : !this.auditable.equals(other.auditable)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        if (this.sku == null ? other.sku != null : !this.sku.equals(other.sku)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }
}

