/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.catalog.dao.SkuDao;
import org.broadleafcommerce.catalog.domain.Sku;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blSkuDao")
public class SkuDaoImpl
implements SkuDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Sku save(Sku sku) {
        if (sku.getId() == null) {
            this.em.persist((Object)sku);
        } else {
            sku = (Sku)this.em.merge((Object)sku);
        }
        return sku;
    }

    @Override
    public Sku readSkuById(Long skuId) {
        return (Sku)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.catalog.domain.Sku"), (Object)skuId);
    }

    @Override
    public Sku readFirstSku() {
        Query query = this.em.createNamedQuery("BC_READ_FIRST_SKU");
        return (Sku)query.getSingleResult();
    }

    @Override
    public List<Sku> readAllSkus() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_SKUS");
        return query.getResultList();
    }

    @Override
    public List<Sku> readSkusById(List<Long> ids) {
        Query query = this.em.createNamedQuery("BC_READ_SKUS_BY_ID");
        query.setParameter("skuIds", ids);
        return query.getResultList();
    }
}

