/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.catalog.dao.ProductDao;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blProductDao")
public class ProductDaoImpl
implements ProductDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public Product save(Product product) {
        if (product.getId() == null) {
            this.em.persist((Object)product);
        } else {
            product = (Product)this.em.merge((Object)product);
        }
        return product;
    }

    @Override
    public Product readProductById(Long productId) {
        return (Product)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.catalog.domain.Product"), (Object)productId);
    }

    @Override
    public List<Product> readProductsByName(String searchName) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME");
        query.setParameter("name", (Object)(searchName + "%"));
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate) {
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY");
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("currentDate", (Object)currentDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsBySku(Long skuId) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_SKU");
        query.setParameter("skuId", (Object)skuId);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readActiveProductsBySku(Long skuId, Date currentDate) {
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_SKU");
        query.setParameter("skuId", (Object)skuId);
        query.setParameter("currentDate", (Object)currentDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }
}

