/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class ProductOptionsProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    private static final Log LOG = LogFactory.getLog(ProductOptionsProcessor.class);
    protected static final Map<Object, String> JSON_CACHE = Collections.synchronizedMap(new LRUMap(500));

    public ProductOptionsProcessor() {
        super("product_options");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("productId"));
        Long productId = (Long)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        Product product = this.catalogService.findProductById(productId);
        if (product != null) {
            this.addAllProductOptionsToModel(arguments, product);
            this.addProductOptionPricingToModel(arguments, product);
        }
    }

    private void addProductOptionPricingToModel(Arguments arguments, Product product) {
        List skus = product.getSkus();
        ArrayList<ProductOptionPricingDTO> skuPricing = new ArrayList<ProductOptionPricingDTO>();
        for (Sku sku : skus) {
            ArrayList<Long> productOptionValueIds = new ArrayList<Long>();
            List productOptionValues = sku.getProductOptionValues();
            for (ProductOptionValue productOptionValue : productOptionValues) {
                productOptionValueIds.add(productOptionValue.getId());
            }
            Long[] values = new Long[productOptionValueIds.size()];
            productOptionValueIds.toArray(values);
            ProductOptionPricingDTO dto = new ProductOptionPricingDTO();
            Money currentPrice = sku.isOnSale() ? sku.getSalePrice() : sku.getRetailPrice();
            dto.setPrice(this.formatPrice(currentPrice));
            dto.setSelectedOptions(values);
            skuPricing.add(dto);
        }
        this.writeJSONToModel(arguments, "skuPricing", skuPricing);
    }

    private void addAllProductOptionsToModel(Arguments arguments, Product product) {
        List productOptions = product.getProductOptions();
        ArrayList<ProductOptionDTO> dtos = new ArrayList<ProductOptionDTO>();
        for (ProductOption option : productOptions) {
            ProductOptionDTO dto = new ProductOptionDTO();
            dto.setId(option.getId());
            dto.setType(option.getType().getType());
            HashMap<Long, String> values = new HashMap<Long, String>();
            for (ProductOptionValue value : option.getAllowedValues()) {
                values.put(value.getId(), value.getAttributeValue());
            }
            dto.setValues(values);
            dtos.add(dto);
        }
        this.writeJSONToModel(arguments, "allProductOptions", dtos);
    }

    private void writeJSONToModel(Arguments arguments, String modelKey, Object o) {
        try {
            String jsonValue = JSON_CACHE.get(o);
            if (jsonValue == null) {
                ObjectMapper mapper = new ObjectMapper();
                StringWriter strWriter = new StringWriter();
                mapper.writeValue((Writer)strWriter, o);
                jsonValue = ((Object)strWriter).toString();
                JSON_CACHE.put(o, jsonValue);
            }
            this.addToModel(arguments, modelKey, jsonValue);
        }
        catch (Exception ex) {
            LOG.error((Object)"There was a problem writing the product option map to JSON", (Throwable)ex);
        }
    }

    private String formatPrice(Money price) {
        if (price == null) {
            return null;
        }
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc.getJavaLocale() != null) {
            return BroadleafCurrencyUtils.getNumberFormatFromCache((Locale)brc.getJavaLocale(), (Currency)price.getCurrency()).format(price.getAmount());
        }
        return "$ " + price.getAmount().toString();
    }

    private class ProductOptionPricingDTO {
        private Long[] skuOptions;
        private String price;

        private ProductOptionPricingDTO() {
        }

        public Long[] getSelectedOptions() {
            return this.skuOptions;
        }

        public void setSelectedOptions(Long[] skuOptions) {
            this.skuOptions = skuOptions;
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().isAssignableFrom(o.getClass())) {
                return false;
            }
            ProductOptionPricingDTO that = (ProductOptionPricingDTO)o;
            if (this.price != null ? !this.price.equals(that.price) : that.price != null) {
                return false;
            }
            return Arrays.equals((Object[])this.skuOptions, (Object[])that.skuOptions);
        }

        public int hashCode() {
            int result = this.skuOptions != null ? Arrays.hashCode((Object[])this.skuOptions) : 0;
            result = 31 * result + (this.price != null ? this.price.hashCode() : 0);
            return result;
        }
    }

    private class ProductOptionDTO {
        private Long id;
        private String type;
        private Map<Long, String> values;
        private String selectedValue;

        private ProductOptionDTO() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<Long, String> getValues() {
            return this.values;
        }

        public void setValues(Map<Long, String> values) {
            this.values = values;
        }

        public String getSelectedValue() {
            return this.selectedValue;
        }

        public void setSelectedValue(String selectedValue) {
            this.selectedValue = selectedValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().isAssignableFrom(o.getClass())) {
                return false;
            }
            ProductOptionDTO that = (ProductOptionDTO)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.selectedValue != null ? !this.selectedValue.equals(that.selectedValue) : that.selectedValue != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            result = 31 * result + (this.selectedValue != null ? this.selectedValue.hashCode() : 0);
            return result;
        }
    }
}

