/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderLockManager;
import org.broadleafcommerce.core.order.service.OrderService;

public class DatabaseOrderLockManager
implements OrderLockManager {
    protected static final Log LOG = LogFactory.getLog(DatabaseOrderLockManager.class);
    @Resource(name="blOrderService")
    protected OrderService orderService;

    public Object acquireLock(Order order) {
        if (order == null || order instanceof NullOrderImpl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Thread[" + Thread.currentThread().getId() + "] Attempted to grab a lock for a NullOrderImpl. "));
            }
            return order;
        }
        boolean lockAcquired = false;
        int count = 0;
        while (!lockAcquired) {
            block9: {
                try {
                    lockAcquired = this.orderService.acquireLock(order);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug((Object)"Couldn't acquire lock - that's ok, we'll retry shortly", (Throwable)e);
                }
            }
            if (lockAcquired) continue;
            if (++count >= this.getDatabaseLockAcquisitionNumRetries()) {
                LOG.warn((Object)String.format("Exceeded max retries to attempt to acquire a lock on current Order (%s)", order.getId()));
                throw new RuntimeException("Exceeded max retries to attempt to acquire a lock on current Order");
            }
            try {
                long msToSleep = this.getDatabaseLockPollingIntervalMs();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Thread[" + Thread.currentThread().getId() + "] Could not acquire order lock for order[" + order.getId() + "] - sleeping for " + msToSleep + " ms"));
                }
                Thread.sleep(msToSleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return order;
    }

    public Object acquireLockIfAvailable(Order order) {
        if (order instanceof NullOrderImpl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempted to grab a lock for a NullOrderImpl. Not blocking");
            }
            return order;
        }
        boolean lockAcquired = this.orderService.acquireLock(order);
        return lockAcquired ? order : null;
    }

    public void releaseLock(Object lockObject) {
        Order order = (Order)lockObject;
        if (order instanceof NullOrderImpl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Thread[" + Thread.currentThread().getId() + "] Attempted to release a lock for a NullOrderImpl"));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Thread[" + Thread.currentThread().getId() + "] releasing lock for order[" + order.getId() + "]"));
            }
            this.orderService.releaseLock(order);
        }
    }

    protected long getDatabaseLockPollingIntervalMs() {
        return BLCSystemProperty.resolveLongSystemProperty((String)"order.lock.databaseLockPollingIntervalMs");
    }

    protected int getDatabaseLockAcquisitionNumRetries() {
        return BLCSystemProperty.resolveIntSystemProperty((String)"order.lock.databaseLockAcquisitionNumRetries", (int)5);
    }

    public boolean isActive() {
        return true;
    }
}

