/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.expression;

import javax.annotation.Resource;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.expression.BroadleafVariableExpression;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogURLService;
import org.springframework.util.StringUtils;

public class BLCVariableExpression
implements BroadleafVariableExpression {
    @Resource(name="blCatalogURLService")
    protected CatalogURLService catalogURLService;

    public String getName() {
        return "blc";
    }

    public String relativeURL(Category category) {
        return this.catalogURLService.buildRelativeCategoryURL(this.getCurrentUrl(), category);
    }

    public String relativeURL(Product product) {
        return this.catalogURLService.buildRelativeProductURL(this.getCurrentUrl(), product);
    }

    public String relativeURL(String baseUrl, Category category) {
        return this.catalogURLService.buildRelativeCategoryURL(baseUrl, category);
    }

    public String relativeURL(String baseUrl, Product product) {
        return this.catalogURLService.buildRelativeProductURL(baseUrl, product);
    }

    protected String getCurrentUrl() {
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        String currentUrl = "";
        if (brc != null && brc.getRequest() != null) {
            currentUrl = brc.getRequest().getRequestURI();
            if (!StringUtils.isEmpty((Object)brc.getRequest().getQueryString())) {
                currentUrl = currentUrl + "?" + brc.getRequest().getQueryString();
            }
        }
        return currentUrl;
    }
}

