/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.web.payment.controller.PaymentGatewayAbstractController;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.exception.IllegalCartOperationException;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.checkout.model.OrderInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.AbstractCheckoutController;
import org.broadleafcommerce.core.web.order.CartState;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafCheckoutController
extends AbstractCheckoutController {
    private static final Log LOG = LogFactory.getLog(BroadleafCheckoutController.class);
    protected static String baseConfirmationRedirect = "redirect:/confirmation";

    public String checkout(HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
        Order cart = CartState.getCart();
        try {
            this.orderService.preValidateCartOperation(cart);
        }
        catch (IllegalCartOperationException ex) {
            model.addAttribute("cartRequiresLock", (Object)true);
        }
        if (!(cart instanceof NullOrderImpl)) {
            model.addAttribute("orderMultishipOptions", (Object)this.orderMultishipOptionService.getOrGenerateOrderMultishipOptions(cart));
            model.addAttribute("paymentRequestDTO", (Object)this.dtoTranslationService.translateOrder(cart));
        }
        this.populateModelWithReferenceData(request, model);
        return this.getCheckoutView();
    }

    public String saveGlobalOrderDetails(HttpServletRequest request, Model model, OrderInfoForm orderInfoForm, BindingResult result) throws ServiceException {
        Order cart = CartState.getCart();
        this.orderInfoFormValidator.validate(orderInfoForm, (Errors)result);
        if (result.hasErrors()) {
            try {
                cart.setEmailAddress(null);
                this.orderService.save(cart, Boolean.valueOf(false));
            }
            catch (PricingException pe) {
                LOG.error((Object)"Error when saving the email address for order confirmation to the cart", (Throwable)pe);
            }
            this.populateModelWithReferenceData(request, model);
            return this.getCheckoutView();
        }
        try {
            cart.setEmailAddress(orderInfoForm.getEmailAddress());
            this.orderService.save(cart, Boolean.valueOf(false));
        }
        catch (PricingException pe) {
            LOG.error((Object)"Error when saving the email address for order confirmation to the cart", (Throwable)pe);
        }
        return this.getCheckoutPageRedirect();
    }

    public String processPassthroughCheckout(RedirectAttributes redirectAttributes, PaymentType paymentType) throws PaymentException, PricingException {
        Order cart = CartState.getCart();
        ArrayList<OrderPayment> paymentsToInvalidate = new ArrayList<OrderPayment>();
        for (OrderPayment payment : cart.getPayments()) {
            if (!payment.isActive()) continue;
            if (payment.getTransactions() == null || payment.getTransactions().isEmpty()) {
                paymentsToInvalidate.add(payment);
                continue;
            }
            for (PaymentTransaction transaction : payment.getTransactions()) {
                if (PaymentTransactionType.UNCONFIRMED.equals((Object)transaction.getType())) continue;
                paymentsToInvalidate.add(payment);
            }
        }
        for (OrderPayment payment : paymentsToInvalidate) {
            cart.getPayments().remove(payment);
            if (this.paymentGatewayCheckoutService == null) continue;
            this.paymentGatewayCheckoutService.markPaymentAsInvalid(payment.getId());
        }
        OrderPayment passthroughPayment = this.orderPaymentService.create();
        passthroughPayment.setType(paymentType);
        passthroughPayment.setPaymentGatewayType(PaymentGatewayType.PASSTHROUGH);
        passthroughPayment.setAmount(cart.getTotalAfterAppliedPayments());
        passthroughPayment.setOrder(cart);
        PaymentTransaction transaction = this.orderPaymentService.createTransaction();
        transaction.setAmount(cart.getTotalAfterAppliedPayments());
        transaction.setRawResponse("Passthrough Payment");
        transaction.setSuccess(Boolean.valueOf(true));
        transaction.setType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        transaction.getAdditionalFields().put("PASSTHROUGH_PAYMENT_TYPE", paymentType.getType());
        transaction.setOrderPayment(passthroughPayment);
        passthroughPayment.addTransaction(transaction);
        this.orderService.addPaymentToOrder(cart, passthroughPayment, null);
        this.orderService.save(cart, Boolean.valueOf(true));
        return this.processCompleteCheckoutOrderFinalized(redirectAttributes);
    }

    public String processCompleteCheckoutOrderFinalized(RedirectAttributes redirectAttributes) throws PaymentException {
        Order cart = CartState.getCart();
        if (cart != null && !(cart instanceof NullOrderImpl)) {
            try {
                String orderNumber = this.initiateCheckout(cart.getId());
                return this.getConfirmationViewRedirect(orderNumber);
            }
            catch (Exception e) {
                this.handleProcessingException(e, redirectAttributes);
            }
        }
        return this.getCheckoutPageRedirect();
    }

    public String initiateCheckout(Long orderId) throws Exception {
        if (this.paymentGatewayCheckoutService != null && orderId != null) {
            return this.paymentGatewayCheckoutService.initiateCheckout(orderId);
        }
        return null;
    }

    public void handleProcessingException(Exception e, RedirectAttributes redirectAttributes) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"A Processing Exception Occurred finalizing the order. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)PaymentGatewayAbstractController.getProcessingErrorMessage());
    }

    public String getBaseConfirmationRedirect() {
        return baseConfirmationRedirect;
    }

    protected String getConfirmationViewRedirect(String orderNumber) {
        return this.getBaseConfirmationRedirect() + "/" + orderNumber;
    }
}

