/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.AbstractCheckoutController;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutControllerExtensionHandler;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafBillingInfoController
extends AbstractCheckoutController {
    public String saveBillingAddress(HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) throws PricingException, ServiceException {
        Address address;
        Boolean useCustomerPayment;
        Order cart = CartState.getCart();
        CustomerPayment customerPayment = null;
        if (billingForm.isUseShippingAddress()) {
            this.copyShippingAddressToBillingAddress(cart, billingForm);
        }
        if ((useCustomerPayment = billingForm.getUseCustomerPayment()).booleanValue() && billingForm.getCustomerPaymentId() != null && (customerPayment = this.customerPaymentService.readCustomerPaymentById(billingForm.getCustomerPaymentId())) != null && (address = customerPayment.getBillingAddress()) != null) {
            this.copyAddressToBillingAddress(billingForm, address);
        }
        this.billingInfoFormValidator.validate(billingForm, (Errors)result);
        if (result.hasErrors()) {
            return this.getCheckoutView();
        }
        if (billingForm.getAddress().getPhonePrimary() != null && StringUtils.isEmpty((String)billingForm.getAddress().getPhonePrimary().getPhoneNumber())) {
            billingForm.getAddress().setPhonePrimary(null);
        }
        if (billingForm.getAddress().getPhoneSecondary() != null && StringUtils.isEmpty((String)billingForm.getAddress().getPhoneSecondary().getPhoneNumber())) {
            billingForm.getAddress().setPhoneSecondary(null);
        }
        if (billingForm.getAddress().getPhoneFax() != null && StringUtils.isEmpty((String)billingForm.getAddress().getPhoneFax().getPhoneNumber())) {
            billingForm.getAddress().setPhoneFax(null);
        }
        boolean found = false;
        String paymentName = billingForm.getPaymentName();
        Boolean saveNewPayment = billingForm.getSaveNewPayment();
        for (OrderPayment p : cart.getPayments()) {
            if (!PaymentType.CREDIT_CARD.equals((Object)p.getType()) || !p.isActive()) continue;
            if (p.getBillingAddress() == null) {
                p.setBillingAddress(billingForm.getAddress());
            } else {
                Address updatedAddress = this.updateAddress(billingForm.getAddress(), p.getBillingAddress());
                p.setBillingAddress(updatedAddress);
            }
            found = true;
        }
        if (!found) {
            OrderPayment tempOrderPayment = this.orderPaymentService.create();
            tempOrderPayment.setType(PaymentType.CREDIT_CARD);
            tempOrderPayment.setPaymentGatewayType(PaymentGatewayType.TEMPORARY);
            tempOrderPayment.setBillingAddress(billingForm.getAddress());
            tempOrderPayment.setOrder(cart);
            cart.getPayments().add(tempOrderPayment);
        }
        this.orderService.save(cart, Boolean.valueOf(true));
        if (this.isAjaxRequest(request)) {
            ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).addAdditionalModelVariables(model);
            return this.getCheckoutView();
        }
        return this.getCheckoutPageRedirect();
    }

    protected void copyShippingAddressToBillingAddress(Order order, BillingInfoForm billingInfoForm) {
        Address shipping;
        if (order.getFulfillmentGroups().get(0) != null && (shipping = ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getAddress()) != null) {
            this.copyAddressToBillingAddress(billingInfoForm, shipping);
        }
    }

    protected void copyAddressToBillingAddress(BillingInfoForm billingInfoForm, Address address) {
        Address billing = this.addressService.create();
        billingInfoForm.setAddress(this.updateAddress(address, billing));
    }

    private Address updateAddress(Address updatedInfoAddress, Address addressToBeUpdated) {
        addressToBeUpdated.setFullName(updatedInfoAddress.getFullName());
        addressToBeUpdated.setFirstName(updatedInfoAddress.getFirstName());
        addressToBeUpdated.setLastName(updatedInfoAddress.getLastName());
        addressToBeUpdated.setAddressLine1(updatedInfoAddress.getAddressLine1());
        addressToBeUpdated.setAddressLine2(updatedInfoAddress.getAddressLine2());
        addressToBeUpdated.setCity(updatedInfoAddress.getCity());
        addressToBeUpdated.setState(updatedInfoAddress.getState());
        addressToBeUpdated.setIsoCountrySubdivision(updatedInfoAddress.getIsoCountrySubdivision());
        addressToBeUpdated.setStateProvinceRegion(updatedInfoAddress.getStateProvinceRegion());
        addressToBeUpdated.setPostalCode(updatedInfoAddress.getPostalCode());
        addressToBeUpdated.setCountry(updatedInfoAddress.getCountry());
        addressToBeUpdated.setIsoCountryAlpha2(updatedInfoAddress.getIsoCountryAlpha2());
        addressToBeUpdated.setPrimaryPhone(updatedInfoAddress.getPrimaryPhone());
        addressToBeUpdated.setSecondaryPhone(updatedInfoAddress.getSecondaryPhone());
        addressToBeUpdated.setFax(updatedInfoAddress.getFax());
        addressToBeUpdated.setPhonePrimary(this.copyPhone(updatedInfoAddress.getPhonePrimary(), addressToBeUpdated.getPhonePrimary()));
        addressToBeUpdated.setPhoneSecondary(this.copyPhone(updatedInfoAddress.getPhoneSecondary(), addressToBeUpdated.getPhoneSecondary()));
        addressToBeUpdated.setPhoneFax(this.copyPhone(updatedInfoAddress.getPhoneFax(), addressToBeUpdated.getPhoneFax()));
        addressToBeUpdated.setEmailAddress(updatedInfoAddress.getEmailAddress());
        return addressToBeUpdated;
    }

    protected Phone copyPhone(Phone phoneToCopy, Phone phoneToUpdate) {
        if (phoneToCopy != null) {
            if (phoneToUpdate == null) {
                phoneToUpdate = this.phoneService.create();
            }
            phoneToUpdate.setPhoneNumber(phoneToCopy.getPhoneNumber());
            return phoneToUpdate;
        }
        return null;
    }
}

