/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlElement;
import org.broadleafcommerce.common.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.springframework.context.ApplicationContext;

public class DimensionWrapper
extends BaseWrapper
implements APIWrapper<Dimension>,
APIUnwrapper<Dimension> {
    @XmlElement
    protected BigDecimal width;
    @XmlElement
    protected BigDecimal height;
    @XmlElement
    protected BigDecimal depth;
    @XmlElement
    protected BigDecimal girth;
    @XmlElement
    protected String container;
    @XmlElement
    protected String size;
    @XmlElement
    protected String dimensionUnitOfMeasure;

    @Override
    public void wrapDetails(Dimension model, HttpServletRequest request) {
        this.width = model.getWidth();
        this.depth = model.getDepth();
        this.height = model.getHeight();
        this.girth = model.getGirth();
        if (model.getDimensionUnitOfMeasure() != null) {
            this.dimensionUnitOfMeasure = model.getDimensionUnitOfMeasure().getType();
        }
        if (model.getSize() != null) {
            this.size = model.getSize().getType();
        }
        if (model.getContainer() != null) {
            this.container = model.getContainer().getType();
        }
    }

    @Override
    public void wrapSummary(Dimension model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getDepth() {
        return this.depth;
    }

    public void setDepth(BigDecimal depth) {
        this.depth = depth;
    }

    public BigDecimal getGirth() {
        return this.girth;
    }

    public void setGirth(BigDecimal girth) {
        this.girth = girth;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getDimensionUnitOfMeasure() {
        return this.dimensionUnitOfMeasure;
    }

    public void setDimensionUnitOfMeasure(String dimensionUnitOfMeasure) {
        this.dimensionUnitOfMeasure = dimensionUnitOfMeasure;
    }

    @Override
    public Dimension unwrap(HttpServletRequest request, ApplicationContext context) {
        Dimension dim = new Dimension();
        dim.setContainer(ContainerShapeType.getInstance((String)this.container));
        dim.setDimensionUnitOfMeasure(DimensionUnitOfMeasureType.getInstance((String)this.dimensionUnitOfMeasure));
        dim.setDepth(this.depth);
        dim.setGirth(this.girth);
        dim.setHeight(this.height);
        dim.setSize(ContainerSizeType.getInstance((String)this.size));
        dim.setWidth(this.width);
        return dim;
    }
}

