/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.util.xml.ISO8601DateAdapter;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AddressWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CustomerWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MapElementWrapper;
import org.broadleafcommerce.core.web.api.wrapper.WrapperAdditionalFields;
import org.broadleafcommerce.profile.core.domain.AdditionalFields;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.CustomerPaymentService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="customerPayment")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomerPaymentWrapper
extends BaseWrapper
implements APIWrapper<CustomerPayment>,
WrapperAdditionalFields,
APIUnwrapper<CustomerPayment> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String paymentToken;
    @XmlElement
    protected Boolean isDefault;
    @XmlElement
    protected AddressWrapper billingAddress;
    @XmlElement
    protected CustomerWrapper customer;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    private Date expirationDate;
    @XmlElement
    private String cardName;
    @XmlElement
    private String lastFour;
    @XmlElement
    private String cardType;
    @XmlElement
    private String paymentGatewayType;
    @XmlElement(name="element")
    @XmlElementWrapper(name="additionalFields")
    protected List<MapElementWrapper> additionalFields;

    @Override
    public void wrapDetails(CustomerPayment model, HttpServletRequest request) {
        this.id = model.getId();
        this.isDefault = model.isDefault();
        if (model.getPaymentToken() != null) {
            this.paymentToken = model.getPaymentToken();
        }
        if (model.getBillingAddress() != null) {
            AddressWrapper addressWrapper = (AddressWrapper)this.context.getBean(AddressWrapper.class.getName());
            addressWrapper.wrapDetails(model.getBillingAddress(), request);
            this.billingAddress = addressWrapper;
        }
        CustomerWrapper customerWrapper = (CustomerWrapper)this.context.getBean(CustomerWrapper.class.getName());
        customerWrapper.wrapDetails(model.getCustomer(), request);
        this.customer = customerWrapper;
        this.additionalFields = super.createElementWrappers((AdditionalFields)model);
    }

    @Override
    public CustomerPayment unwrap(HttpServletRequest request, ApplicationContext context) {
        CustomerPaymentService custPayService = (CustomerPaymentService)context.getBean("blCustomerPaymentService");
        CustomerPayment custPay = custPayService.create();
        AddressService addressService = (AddressService)context.getBean("blAddressService");
        Address billingAddress = addressService.readAddressById(this.billingAddress.getId());
        custPay.setBillingAddress(billingAddress);
        CustomerService customerService = (CustomerService)context.getBean("blCustomerService");
        Customer cust = customerService.readCustomerById(this.customer.getId());
        custPay.setCustomer(cust);
        custPay.setIsDefault(this.isDefault.booleanValue());
        custPay.setPaymentToken(this.getPaymentToken());
        super.transferAdditionalFieldsFromWrapper(this, (AdditionalFields)custPay);
        return custPay;
    }

    @Override
    public void wrapSummary(CustomerPayment model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPaymentToken() {
        return this.paymentToken;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public AddressWrapper getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressWrapper billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CustomerWrapper getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerWrapper customer) {
        this.customer = customer;
    }

    @Override
    public List<MapElementWrapper> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(List<MapElementWrapper> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getCardName() {
        return this.cardName;
    }

    public void setCardName(String cardName) {
        this.cardName = cardName;
    }

    public String getLastFour() {
        return this.lastFour;
    }

    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getPaymentGatewayType() {
        return this.paymentGatewayType;
    }

    public void setPaymentGatewayType(String paymentGatewayType) {
        this.paymentGatewayType = paymentGatewayType;
    }
}

