/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import java.util.Locale;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.util.ApplicationContextHolder;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.wrapper.ErrorMessageWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ErrorWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;

public class BroadleafSpringRestExceptionMapper {
    private static final Log LOG = LogFactory.getLog(BroadleafSpringRestExceptionMapper.class);
    protected String messageKeyPrefix = BroadleafWebServicesException.class.getName() + '.';
    @Resource(name="messageSource")
    protected MessageSource messageSource;
    protected ApplicationContext context = ApplicationContextHolder.getApplicationContext();

    @ExceptionHandler(value={BroadleafWebServicesException.class})
    @ResponseBody
    public ErrorWrapper handleBroadleafWebServicesException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        BroadleafWebServicesException blcException = (BroadleafWebServicesException)ex;
        Locale locale = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        if (ex.getCause() != null) {
            LOG.error((Object)"An error occured invoking a REST service.", ex.getCause());
        }
        errorWrapper.setHttpStatusCode(blcException.getHttpStatusCode());
        response.setStatus(this.resolveResponseStatusCode(ex, errorWrapper));
        if (blcException.getLocale() != null) {
            locale = blcException.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (blcException.getMessages() != null && !blcException.getMessages().isEmpty()) {
            Set<String> keys = blcException.getMessages().keySet();
            for (String key : keys) {
                ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
                errorMessageWrapper.setMessageKey(this.resolveClientMessageKey(key));
                errorMessageWrapper.setMessage(this.messageSource.getMessage(key, blcException.getMessages().get(key), key, locale));
                errorWrapper.getMessages().add(errorMessageWrapper);
            }
        } else {
            ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
            errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError"));
            errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", null, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", locale));
            errorWrapper.getMessages().add(errorMessageWrapper);
        }
        return errorWrapper;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    public ErrorWrapper handleNoHandlerFoundException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        Locale locale = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        LOG.error((Object)"An error occured invoking a REST service", (Throwable)ex);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        errorWrapper.setHttpStatusCode(404);
        response.setStatus(this.resolveResponseStatusCode(ex, errorWrapper));
        ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
        errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.notFound"));
        errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.notFound", null, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.notFound", locale));
        errorWrapper.getMessages().add(errorMessageWrapper);
        return errorWrapper;
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public ErrorWrapper handleHttpMediaTypeNotSupportedException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        Locale locale = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        LOG.error((Object)"An error occured invoking a REST service", (Throwable)ex);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        errorWrapper.setHttpStatusCode(415);
        response.setStatus(this.resolveResponseStatusCode(ex, errorWrapper));
        ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
        errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.contentTypeNotSupported"));
        errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.contentTypeNotSupported", (Object[])new String[]{request.getContentType()}, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.contentTypeNotSupported", locale));
        errorWrapper.getMessages().add(errorMessageWrapper);
        return errorWrapper;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ErrorWrapper handleMissingServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        Locale locale = null;
        String parameterType = null;
        String parameterName = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        if (ex instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException castedException = (MissingServletRequestParameterException)ex;
            parameterType = castedException.getParameterType();
            parameterName = castedException.getParameterName();
        }
        LOG.error((Object)"An error occured invoking a REST service", (Throwable)ex);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (parameterType == null) {
            parameterType = "String";
        }
        if (parameterName == null) {
            parameterName = "[unknown name]";
        }
        errorWrapper.setHttpStatusCode(400);
        response.setStatus(this.resolveResponseStatusCode(ex, errorWrapper));
        ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
        errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.queryParameterNotPresent"));
        errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.queryParameterNotPresent", (Object[])new String[]{parameterType, parameterName}, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.queryParameterNotPresent", locale));
        errorWrapper.getMessages().add(errorMessageWrapper);
        return errorWrapper;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorWrapper handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        Locale locale = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        LOG.error((Object)"An error occured invoking a REST service", (Throwable)ex);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        errorWrapper.setHttpStatusCode(500);
        response.setStatus(this.resolveResponseStatusCode(ex, errorWrapper));
        ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
        errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError"));
        errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", null, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", locale));
        errorWrapper.getMessages().add(errorMessageWrapper);
        return errorWrapper;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setMessageKeyPrefix(String prefix) {
        this.messageKeyPrefix = prefix;
    }

    protected int resolveResponseStatusCode(Throwable t, ErrorWrapper error) {
        if (error.getHttpStatusCode() == null) {
            return 500;
        }
        return error.getHttpStatusCode();
    }

    protected String resolveClientMessageKey(String key) {
        if (this.messageKeyPrefix != null) {
            return StringUtils.remove((String)key, (String)this.messageKeyPrefix);
        }
        return key;
    }
}

