/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.service.ExploitProtectionService;
import org.broadleafcommerce.common.util.StringUtil;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.inventory.service.InventoryService;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.SkuAccessor;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.core.web.processor.extension.UncacheableDataProcessorExtensionHandler;
import org.broadleafcommerce.core.web.processor.extension.UncacheableDataProcessorExtensionManager;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.factory.annotation.Value;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;

public class UncacheableDataProcessor
extends AbstractElementProcessor {
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Resource(name="blInventoryService")
    protected InventoryService inventoryService;
    @Resource(name="blExploitProtectionService")
    protected ExploitProtectionService eps;
    @Resource(name="blUncacheableDataProcessorExtensionManager")
    protected UncacheableDataProcessorExtensionManager extensionManager;
    private String defaultCallbackFunction = "updateUncacheableData(params)";

    public UncacheableDataProcessor() {
        super("uncacheabledata");
    }

    public int getPrecedence() {
        return 100;
    }

    protected ProcessorResult processElement(Arguments arguments, Element element) {
        StringBuffer sb = new StringBuffer();
        sb.append("<SCRIPT>\n");
        sb.append("  var params = \n  ");
        sb.append(this.buildContentMap(arguments)).append(";\n  ");
        sb.append(this.getUncacheableDataFunction(arguments, element)).append(";\n");
        sb.append("</SCRIPT>");
        Macro contentNode = new Macro(sb.toString());
        element.clearChildren();
        element.getParent().insertAfter((Node)element, (Node)contentNode);
        element.getParent().removeChild((Node)element);
        return ProcessorResult.OK;
    }

    protected String buildContentMap(Arguments arguments) {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        this.addCartData(attrMap);
        this.addCustomerData(attrMap);
        this.addProductInventoryData(attrMap, arguments);
        try {
            attrMap.put("csrfToken", this.eps.getCSRFToken());
            attrMap.put("csrfTokenParameter", this.eps.getCsrfTokenParameter());
        }
        catch (ServiceException e) {
            throw new RuntimeException("Could not get a CSRF token for this session", e);
        }
        return StringUtil.getMapAsJson(attrMap);
    }

    protected void addProductInventoryData(Map<String, Object> attrMap, Arguments arguments) {
        ArrayList<Long> outOfStockProducts = new ArrayList<Long>();
        ArrayList<Long> outOfStockSkus = new ArrayList<Long>();
        HashSet<Product> allProducts = new HashSet<Product>();
        HashSet<Sku> allSkus = new HashSet<Sku>();
        Set products = (Set)((Map)arguments.getExpressionEvaluationRoot()).get("blcAllDisplayedProducts");
        Set skus = (Set)((Map)arguments.getExpressionEvaluationRoot()).get("blcAllDisplayedSkus");
        if (!CollectionUtils.isEmpty((Collection)products)) {
            allProducts.addAll(products);
        }
        if (!CollectionUtils.isEmpty((Collection)skus)) {
            allSkus.addAll(skus);
        }
        ((UncacheableDataProcessorExtensionHandler)this.extensionManager.getProxy()).modifyProductListForInventoryCheck(arguments, allProducts, allSkus);
        if (!allProducts.isEmpty()) {
            for (Product product : allProducts) {
                Boolean qtyAvailable;
                if (product.getDefaultSku() == null || (qtyAvailable = Boolean.valueOf(this.inventoryService.isAvailable(product.getDefaultSku(), 1))) == null || qtyAvailable.booleanValue()) continue;
                outOfStockProducts.add(product.getId());
            }
        } else if (!allSkus.isEmpty()) {
            Map inventoryAvailable = this.inventoryService.retrieveQuantitiesAvailable(allSkus);
            for (Map.Entry entry : inventoryAvailable.entrySet()) {
                if (entry.getValue() != null && (Integer)entry.getValue() >= 1) continue;
                outOfStockSkus.add(((Sku)entry.getKey()).getId());
            }
        }
        attrMap.put("outOfStockProducts", outOfStockProducts);
        attrMap.put("outOfStockSkus", outOfStockSkus);
    }

    protected void addCartData(Map<String, Object> attrMap) {
        Order cart = CartState.getCart();
        int cartQty = 0;
        ArrayList<Long> cartItemIdsWithOptions = new ArrayList<Long>();
        ArrayList<Long> cartItemIdsWithoutOptions = new ArrayList<Long>();
        if (cart != null && cart.getOrderItems() != null) {
            cartQty = cart.getItemCount();
            for (OrderItem item : cart.getOrderItems()) {
                Sku sku;
                if (!(item instanceof SkuAccessor) || (sku = ((SkuAccessor)item).getSku()) == null || sku.getProduct() == null) continue;
                if (this.useSku) {
                    cartItemIdsWithoutOptions.add(sku.getId());
                    continue;
                }
                Product product = sku.getProduct();
                List optionXrefs = product.getProductOptionXrefs();
                if (optionXrefs == null || optionXrefs.isEmpty()) {
                    cartItemIdsWithoutOptions.add(product.getId());
                    continue;
                }
                cartItemIdsWithOptions.add(product.getId());
            }
        }
        attrMap.put("cartItemCount", cartQty);
        attrMap.put("cartItemIdsWithOptions", cartItemIdsWithOptions);
        attrMap.put("cartItemIdsWithoutOptions", cartItemIdsWithoutOptions);
    }

    protected void addCustomerData(Map<String, Object> attrMap) {
        Customer customer = CustomerState.getCustomer();
        String firstName = "";
        String lastName = "";
        boolean anonymous = false;
        if (customer != null) {
            if (!StringUtils.isEmpty((CharSequence)customer.getFirstName())) {
                firstName = customer.getFirstName();
            }
            if (!StringUtils.isEmpty((CharSequence)customer.getLastName())) {
                lastName = customer.getLastName();
            }
            if (customer.isAnonymous()) {
                anonymous = true;
            }
        }
        attrMap.put("firstName", firstName);
        attrMap.put("lastName", lastName);
        attrMap.put("anonymous", anonymous);
    }

    public String getUncacheableDataFunction(Arguments arguments, Element element) {
        if (element.hasAttribute("callback")) {
            return element.getAttributeValue("callback");
        }
        return this.getDefaultCallbackFunction();
    }

    public String getDefaultCallbackFunction() {
        return this.defaultCallbackFunction;
    }

    public void setDefaultCallbackFunction(String defaultCallbackFunction) {
        this.defaultCallbackFunction = defaultCallbackFunction;
    }
}

