/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogURLService;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class CatalogRelativeHrefProcessor
extends AbstractAttributeModifierAttrProcessor {
    private static final String RHREF = "rhref";
    private static final String HREF = "href";
    @Resource(name="blCatalogURLService")
    protected CatalogURLService catalogURLService;

    public CatalogRelativeHrefProcessor() {
        super(RHREF);
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue(attributeName));
        HttpServletRequest request = BroadleafRequestContext.getBroadleafRequestContext().getRequest();
        String relativeHref = this.buildRelativeHref(expression, arguments, request);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(HREF, relativeHref);
        return attrs;
    }

    protected String buildRelativeHref(Expression expression, Arguments arguments, HttpServletRequest request) {
        Object result = expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        String currentUrl = request.getRequestURI();
        if (request.getQueryString() != null) {
            currentUrl = currentUrl + "?" + request.getQueryString();
        }
        if (result instanceof Product) {
            return this.catalogURLService.buildRelativeProductURL(currentUrl, (Product)result);
        }
        if (result instanceof Category) {
            return this.catalogURLService.buildRelativeCategoryURL(currentUrl, (Category)result);
        }
        return "";
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }

    public int getPrecedence() {
        return 0;
    }
}

