/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.controller.validator.RegisterCustomerValidator;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.broadleafcommerce.profile.web.core.service.login.LoginService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafRegisterController
extends BroadleafAbstractController {
    @Value(value="${use.email.for.site.login:true}")
    protected boolean useEmailForLogin;
    protected static String registerSuccessView = "ajaxredirect:";
    protected static String registerView = "authentication/register";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blRegisterCustomerValidator")
    protected RegisterCustomerValidator registerCustomerValidator;
    @Resource(name="blLoginService")
    protected LoginService loginService;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    public String register(RegisterCustomerForm registerCustomerForm, HttpServletRequest request, HttpServletResponse response, Model model) {
        String redirectUrl = request.getParameter("successUrl");
        if (StringUtils.isNotBlank((String)redirectUrl)) {
            registerCustomerForm.setRedirectUrl(redirectUrl);
        }
        return this.getRegisterView();
    }

    public String processRegister(RegisterCustomerForm registerCustomerForm, BindingResult errors, HttpServletRequest request, HttpServletResponse response, Model model) throws ServiceException, PricingException {
        if (this.useEmailForLogin) {
            Customer customer = registerCustomerForm.getCustomer();
            customer.setUsername(customer.getEmailAddress());
        }
        this.registerCustomerValidator.validate((Object)registerCustomerForm, (Errors)errors, this.useEmailForLogin);
        if (!errors.hasErrors()) {
            String redirectUrl;
            Customer newCustomer = this.customerService.registerCustomer(registerCustomerForm.getCustomer(), registerCustomerForm.getPassword(), registerCustomerForm.getPasswordConfirm());
            assert (newCustomer != null);
            this.loginService.loginCustomer(registerCustomerForm.getCustomer());
            Order cart = CartState.getCart();
            if (cart != null && !(cart instanceof NullOrderImpl) && cart.getEmailAddress() == null) {
                cart.setEmailAddress(newCustomer.getEmailAddress());
                this.orderService.save(cart, Boolean.valueOf(false));
            }
            if (StringUtils.isNotBlank((String)(redirectUrl = registerCustomerForm.getRedirectUrl())) && redirectUrl.contains(":")) {
                redirectUrl = null;
            }
            return StringUtils.isBlank((String)redirectUrl) ? this.getRegisterSuccessView() : "redirect:" + redirectUrl;
        }
        return this.getRegisterView();
    }

    public RegisterCustomerForm initCustomerRegistrationForm() {
        Customer customer = CustomerState.getCustomer();
        if (customer == null || !customer.isAnonymous()) {
            customer = this.customerService.createCustomerFromId(null);
        }
        RegisterCustomerForm customerRegistrationForm = new RegisterCustomerForm();
        customerRegistrationForm.setCustomer(customer);
        return customerRegistrationForm;
    }

    public boolean isUseEmailForLogin() {
        return this.useEmailForLogin;
    }

    public void setUseEmailForLogin(boolean useEmailForLogin) {
        this.useEmailForLogin = useEmailForLogin;
    }

    public String getRegisterSuccessView() {
        return registerSuccessView;
    }

    public String getRegisterView() {
        return registerView;
    }
}

