/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BLCAbstractHandlerMapping;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;

public class CategoryHandlerMapping
extends BLCAbstractHandlerMapping {
    private static final Log LOG = LogFactory.getLog(CategoryHandlerMapping.class);
    private String controllerName = "blCategoryController";
    protected String defaultTemplateName = "catalog/category";
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    public static final String CURRENT_CATEGORY_ATTRIBUTE_NAME = "category";
    @Value(value="${request.uri.encoding}")
    public String charEncoding;

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null) {
            Category category = null;
            if (this.allowCategoryResolutionUsingIdParam()) {
                category = this.findCategoryUsingIdParam(context);
            }
            if (category == null) {
                category = this.findCategoryUsingUrl(context);
            }
            if (category != null) {
                context.getRequest().setAttribute(CURRENT_CATEGORY_ATTRIBUTE_NAME, (Object)category);
                return this.controllerName;
            }
        }
        return null;
    }

    public String getDefaultTemplateName() {
        return this.defaultTemplateName;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }

    protected Category findCategoryUsingIdParam(BroadleafRequestContext context) throws ServletRequestBindingException {
        Long categoryId = ServletRequestUtils.getLongParameter((ServletRequest)context.getRequest(), (String)"categoryId");
        if (categoryId != null) {
            Category category = this.catalogService.findCategoryById(categoryId);
            if (category != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obtained the category using ID=" + categoryId));
            }
            return category;
        }
        return null;
    }

    protected Category findCategoryUsingUrl(BroadleafRequestContext context) throws ServletRequestBindingException, UnsupportedEncodingException {
        String requestUri = URLDecoder.decode(context.getRequestURIWithoutContext(), this.charEncoding);
        Category category = this.catalogService.findCategoryByURI(requestUri);
        if (category != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained the category using URI=" + requestUri));
        }
        return category;
    }

    public boolean allowCategoryResolutionUsingIdParam() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"allowCategoryResolutionUsingIdParam");
    }
}

