/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.breadcrumbs;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTO;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTOType;
import org.broadleafcommerce.common.breadcrumbs.service.BreadcrumbServiceExtensionManager;
import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.web.breadcrumbs.AbstractBreadcrumbServiceExtensionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="blSearchBreadcrumbServiceExtensionHandler")
public class SimpleSearchBreadcrumbServiceExtensionHandler
extends AbstractBreadcrumbServiceExtensionHandler {
    @Value(value="${breadcrumb.removeAllParamsExceptCategoryId:true}")
    protected boolean removeAllParamsExceptCategoryId;
    @Resource(name="blBreadcrumbServiceExtensionManager")
    protected BreadcrumbServiceExtensionManager extensionManager;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler((ExtensionHandler)this);
        }
    }

    @Override
    public ExtensionResultStatusType modifyBreadcrumbList(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        String keyword = this.getSearchKeyword(url, params);
        url = this.getBreadcrumbUrl(url, holder);
        params = this.getBreadcrumbParams(params, holder);
        if (!StringUtils.isEmpty((Object)keyword)) {
            BreadcrumbDTO searchDto = new BreadcrumbDTO();
            searchDto.setText(keyword);
            searchDto.setLink(this.buildLink(url, params));
            searchDto.setType(BreadcrumbDTOType.SEARCH);
            ((List)holder.getResult()).add(0, searchDto);
            this.updateContextMap(params, holder);
        }
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected String getBreadcrumbUrl(String url, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        Map contextMap = holder.getContextMap();
        if (contextMap.containsKey(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_URL)) {
            return (String)contextMap.get(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_URL);
        }
        return url;
    }

    protected Map<String, String[]> getBreadcrumbParams(Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        Map contextMap = holder.getContextMap();
        if (contextMap.containsKey(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_PARAMS)) {
            return (Map)contextMap.get(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_PARAMS);
        }
        return params;
    }

    protected void updateContextMap(Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        if (params != null && params.containsKey(this.getKeywordParam())) {
            params.remove(this.getKeywordParam());
            if (this.removeAllParamsExceptCategoryId) {
                Iterator<Map.Entry<String, String[]>> it = params.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String[]> entry = it.next();
                    if ("categoryId".equals(entry.getKey())) continue;
                    it.remove();
                }
            }
            Map contextMap = holder.getContextMap();
            contextMap.put(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_PARAMS, params);
        }
    }

    public String getSearchKeyword(String url, Map<String, String[]> params) {
        String[] keywords;
        if (params != null && params.containsKey(this.getKeywordParam()) && (keywords = params.get(this.getKeywordParam())) != null && keywords.length > 0) {
            return keywords[0];
        }
        return null;
    }

    protected String getKeywordParam() {
        return "q";
    }

    @Override
    public int getDefaultPriority() {
        return 3000;
    }
}

