/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderAttribute;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.ActivityMessageDTO;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AdjustmentWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CartMessageWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CustomerWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderPaymentWrapper;

@XmlRootElement(name="order")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderWrapper
extends BaseWrapper
implements APIWrapper<Order> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String status;
    @XmlElement
    protected Money totalTax;
    @XmlElement
    protected Money totalShipping;
    @XmlElement
    protected Money subTotal;
    @XmlElement
    protected Money total;
    @XmlElement
    protected CustomerWrapper customer;
    @XmlElement(name="orderItem")
    @XmlElementWrapper(name="orderItems")
    protected List<OrderItemWrapper> orderItems;
    @XmlElement(name="fulfillmentGroup")
    @XmlElementWrapper(name="fulfillmentGroups")
    protected List<FulfillmentGroupWrapper> fulfillmentGroups;
    @XmlElement(name="payment")
    @XmlElementWrapper(name="payments")
    protected List<OrderPaymentWrapper> payments;
    @XmlElement(name="orderAdjustment")
    @XmlElementWrapper(name="orderAdjustments")
    protected List<AdjustmentWrapper> orderAdjustments;
    @XmlElement(name="orderAttribute")
    @XmlElementWrapper(name="orderAttributes")
    protected List<OrderAttributeWrapper> orderAttributes;
    @XmlElement(name="cartMessages")
    @XmlElementWrapper(name="cartMessages")
    protected List<CartMessageWrapper> cartMessages;

    @Override
    public void wrapDetails(Order model, HttpServletRequest request) {
        this.id = model.getId();
        if (model.getStatus() != null) {
            this.status = model.getStatus().getType();
        }
        this.totalTax = model.getTotalTax();
        this.totalShipping = model.getTotalShipping();
        this.subTotal = model.getSubTotal();
        this.total = model.getTotal();
        if (model.getOrderItems() != null && !model.getOrderItems().isEmpty()) {
            this.orderItems = new ArrayList<OrderItemWrapper>();
            for (OrderItem orderItem : model.getOrderItems()) {
                OrderItemWrapper orderItemWrapper = (OrderItemWrapper)this.context.getBean(OrderItemWrapper.class.getName());
                orderItemWrapper.wrapSummary(orderItem, request);
                this.orderItems.add(orderItemWrapper);
            }
        }
        if (model.getFulfillmentGroups() != null && !model.getFulfillmentGroups().isEmpty()) {
            this.fulfillmentGroups = new ArrayList<FulfillmentGroupWrapper>();
            for (FulfillmentGroup fulfillmentGroup : model.getFulfillmentGroups()) {
                FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                fulfillmentGroupWrapper.wrapSummary(fulfillmentGroup, request);
                this.fulfillmentGroups.add(fulfillmentGroupWrapper);
            }
        }
        if (model.getPayments() != null && !model.getPayments().isEmpty()) {
            this.payments = new ArrayList<OrderPaymentWrapper>();
            for (OrderPayment payment : model.getPayments()) {
                OrderPaymentWrapper paymentWrapper = (OrderPaymentWrapper)this.context.getBean(OrderPaymentWrapper.class.getName());
                paymentWrapper.wrapSummary(payment, request);
                this.payments.add(paymentWrapper);
            }
        }
        if (model.getOrderAdjustments() != null && !model.getOrderAdjustments().isEmpty()) {
            this.orderAdjustments = new ArrayList<AdjustmentWrapper>();
            for (OrderAdjustment orderAdjustment : model.getOrderAdjustments()) {
                AdjustmentWrapper orderAdjustmentWrapper = (AdjustmentWrapper)this.context.getBean(AdjustmentWrapper.class.getName());
                orderAdjustmentWrapper.wrapSummary((Adjustment)orderAdjustment, request);
                this.orderAdjustments.add(orderAdjustmentWrapper);
            }
        }
        if (model.getOrderAttributes() != null && !model.getOrderAttributes().isEmpty()) {
            Map itemAttributes = model.getOrderAttributes();
            this.orderAttributes = new ArrayList<OrderAttributeWrapper>();
            Set keys = itemAttributes.keySet();
            for (String key : keys) {
                OrderAttributeWrapper orderAttributeWrapper = (OrderAttributeWrapper)this.context.getBean(OrderAttributeWrapper.class.getName());
                orderAttributeWrapper.wrapSummary((OrderAttribute)itemAttributes.get(key), request);
                this.orderAttributes.add(orderAttributeWrapper);
            }
        }
        CustomerWrapper customerWrapper = (CustomerWrapper)this.context.getBean(CustomerWrapper.class.getName());
        customerWrapper.wrapDetails(model.getCustomer(), request);
        this.customer = customerWrapper;
        if (model.getOrderMessages() != null && !model.getOrderMessages().isEmpty()) {
            for (ActivityMessageDTO dto : model.getOrderMessages()) {
                CartMessageWrapper cartMessageWrapper = (CartMessageWrapper)this.context.getBean(CartMessageWrapper.class.getName());
                cartMessageWrapper.wrapSummary(dto, request);
                if (this.cartMessages == null) {
                    this.cartMessages = new ArrayList<CartMessageWrapper>();
                }
                this.cartMessages.add(cartMessageWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(Order model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Money getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Money totalTax) {
        this.totalTax = totalTax;
    }

    public Money getTotalShipping() {
        return this.totalShipping;
    }

    public void setTotalShipping(Money totalShipping) {
        this.totalShipping = totalShipping;
    }

    public Money getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Money subTotal) {
        this.subTotal = subTotal;
    }

    public Money getTotal() {
        return this.total;
    }

    public void setTotal(Money total) {
        this.total = total;
    }

    public CustomerWrapper getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerWrapper customer) {
        this.customer = customer;
    }

    public List<OrderItemWrapper> getOrderItems() {
        return this.orderItems;
    }

    public void setOrderItems(List<OrderItemWrapper> orderItems) {
        this.orderItems = orderItems;
    }

    public List<FulfillmentGroupWrapper> getFulfillmentGroups() {
        return this.fulfillmentGroups;
    }

    public void setFulfillmentGroups(List<FulfillmentGroupWrapper> fulfillmentGroups) {
        this.fulfillmentGroups = fulfillmentGroups;
    }

    public List<OrderPaymentWrapper> getPayments() {
        return this.payments;
    }

    public void setPayments(List<OrderPaymentWrapper> payments) {
        this.payments = payments;
    }

    public List<AdjustmentWrapper> getOrderAdjustments() {
        return this.orderAdjustments;
    }

    public void setOrderAdjustments(List<AdjustmentWrapper> orderAdjustments) {
        this.orderAdjustments = orderAdjustments;
    }

    public List<OrderAttributeWrapper> getOrderAttributes() {
        return this.orderAttributes;
    }

    public void setOrderAttributes(List<OrderAttributeWrapper> orderAttributes) {
        this.orderAttributes = orderAttributes;
    }

    public List<CartMessageWrapper> getCartMessages() {
        return this.cartMessages;
    }

    public void setCartMessages(List<CartMessageWrapper> cartMessages) {
        this.cartMessages = cartMessages;
    }
}

