/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.web.validator;

import javax.annotation.Resource;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.form.BroadleafFormType;
import org.broadleafcommerce.common.web.validator.BroadleafCommonAddressValidatorExtensionHandler;
import org.broadleafcommerce.common.web.validator.BroadleafCommonAddressValidatorExtensionManager;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class BroadleafCommonAddressValidator {
    @Resource(name="blBroadleafCommonAddressValidatorExtensionManager")
    protected BroadleafCommonAddressValidatorExtensionManager validatorExtensionManager;

    public boolean isValidateFullNameOnly() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"validator.address.fullNameOnly");
    }

    public boolean isCustomValidationEnabled() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"validator.custom.enabled");
    }

    public void validate(BroadleafFormType formType, Address address, Errors errors) {
        if (this.isCustomValidationEnabled()) {
            ((BroadleafCommonAddressValidatorExtensionHandler)this.validatorExtensionManager.getProxy()).validate(formType, address, errors);
            return;
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.addressLine1", (String)"addressLine1.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.city", (String)"city.required");
        if (this.isValidateFullNameOnly()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.fullName", (String)"fullName.required");
        } else {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.firstName", (String)"firstName.required");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.lastName", (String)"lastName.required");
        }
        if (address.getIsoCountryAlpha2() == null && address.getCountry() == null) {
            errors.rejectValue("address.isoCountryAlpha2", "country.required", null, null);
        }
    }
}

