/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;

public class PaginationSortLinkProcessor
extends AbstractAttributeModifierAttrProcessor {
    public PaginationSortLinkProcessor() {
        super("pagination-sort-link");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        HttpServletRequest request = BroadleafRequestContext.getBroadleafRequestContext().getRequest();
        String baseUrl = request.getRequestURL().toString();
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        String sort = element.getAttributeValue(attributeName);
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            params.put(SearchCriteria.SORT_STRING, new String[]{sort});
        } else {
            params.remove(SearchCriteria.SORT_STRING);
        }
        params.remove(SearchCriteria.PAGE_NUMBER);
        String url = ProcessorUtils.getUrl(baseUrl, params);
        attributes.put("href", url);
        return attributes;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

