/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.checkout.model.MultiShipInstructionForm;
import org.broadleafcommerce.core.web.checkout.model.OrderMultishipOptionForm;
import org.broadleafcommerce.core.web.checkout.model.ShippingInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.AbstractCheckoutController;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutControllerExtensionHandler;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafShippingInfoController
extends AbstractCheckoutController {
    protected static String multishipView = "checkout/multiship";
    protected static String multishipAddAddressView = "checkout/multishipAddAddressForm";
    protected static String multishipAddAddressSuccessView = "redirect:/checkout/multiship";
    protected static String multishipSuccessView = "redirect:/checkout";

    public String getMultishipView() {
        return multishipView;
    }

    public String getMultishipAddAddressView() {
        return multishipAddAddressView;
    }

    public String getMultishipSuccessView() {
        return multishipSuccessView;
    }

    public String getMultishipAddAddressSuccessView() {
        return multishipAddAddressSuccessView;
    }

    public String convertToSingleship(HttpServletRequest request, HttpServletResponse response, Model model) throws PricingException {
        Order cart = CartState.getCart();
        this.fulfillmentGroupService.collapseToOneShippableFulfillmentGroup(cart, true);
        ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).performAdditionalShippingAction();
        return this.getCheckoutPageRedirect();
    }

    public String saveSingleShip(HttpServletRequest request, HttpServletResponse response, Model model, ShippingInfoForm shippingForm, BindingResult result) throws PricingException, ServiceException {
        FulfillmentGroup shippableFulfillmentGroup;
        Order cart = CartState.getCart();
        if (shippingForm.isUseBillingAddress()) {
            this.copyBillingAddressToShippingAddress(cart, shippingForm);
        }
        this.shippingInfoFormValidator.validate(shippingForm, (Errors)result);
        if (result.hasErrors()) {
            return this.getCheckoutView();
        }
        if (shippingForm.getAddress().getPhonePrimary() != null && StringUtils.isEmpty((String)shippingForm.getAddress().getPhonePrimary().getPhoneNumber())) {
            shippingForm.getAddress().setPhonePrimary(null);
        }
        if (shippingForm.getAddress().getPhoneSecondary() != null && StringUtils.isEmpty((String)shippingForm.getAddress().getPhoneSecondary().getPhoneNumber())) {
            shippingForm.getAddress().setPhoneSecondary(null);
        }
        if (shippingForm.getAddress().getPhoneFax() != null && StringUtils.isEmpty((String)shippingForm.getAddress().getPhoneFax().getPhoneNumber())) {
            shippingForm.getAddress().setPhoneFax(null);
        }
        if ((shippableFulfillmentGroup = this.fulfillmentGroupService.getFirstShippableFulfillmentGroup(cart)) != null) {
            shippableFulfillmentGroup.setAddress(shippingForm.getAddress());
            shippableFulfillmentGroup.setPersonalMessage(shippingForm.getPersonalMessage());
            shippableFulfillmentGroup.setDeliveryInstruction(shippingForm.getDeliveryMessage());
            FulfillmentOption fulfillmentOption = this.fulfillmentOptionService.readFulfillmentOptionById(shippingForm.getFulfillmentOptionId());
            shippableFulfillmentGroup.setFulfillmentOption(fulfillmentOption);
            cart = this.orderService.save(cart, Boolean.valueOf(true));
        }
        ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).performAdditionalShippingAction();
        if (this.isAjaxRequest(request)) {
            ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).addAdditionalModelVariables(model);
            return this.getCheckoutView();
        }
        return this.getCheckoutPageRedirect();
    }

    protected void copyBillingAddressToShippingAddress(Order order, ShippingInfoForm shippingInfoForm) {
        if (order.getPayments() != null) {
            for (OrderPayment payment : order.getPayments()) {
                Address billing;
                if (!payment.isActive() || !PaymentType.CREDIT_CARD.equals((Object)payment.getType()) || (billing = payment.getBillingAddress()) == null) continue;
                Address shipping = this.addressService.create();
                shipping.setFullName(billing.getFullName());
                shipping.setFirstName(billing.getFirstName());
                shipping.setLastName(billing.getLastName());
                shipping.setAddressLine1(billing.getAddressLine1());
                shipping.setAddressLine2(billing.getAddressLine2());
                shipping.setCity(billing.getCity());
                shipping.setState(billing.getState());
                shipping.setIsoCountrySubdivision(billing.getIsoCountrySubdivision());
                shipping.setStateProvinceRegion(billing.getStateProvinceRegion());
                shipping.setPostalCode(billing.getPostalCode());
                shipping.setCountry(billing.getCountry());
                shipping.setIsoCountryAlpha2(billing.getIsoCountryAlpha2());
                shipping.setPrimaryPhone(billing.getPrimaryPhone());
                shipping.setSecondaryPhone(billing.getSecondaryPhone());
                shipping.setFax(billing.getFax());
                shipping.setPhonePrimary(this.copyPhone(billing.getPhonePrimary()));
                shipping.setPhoneSecondary(this.copyPhone(billing.getPhoneSecondary()));
                shipping.setPhoneFax(this.copyPhone(billing.getPhoneFax()));
                shipping.setEmailAddress(billing.getEmailAddress());
                shippingInfoForm.setAddress(shipping);
            }
        }
    }

    protected Phone copyPhone(Phone phoneToCopy) {
        if (phoneToCopy != null) {
            Phone copy = this.phoneService.create();
            copy.setPhoneNumber(phoneToCopy.getPhoneNumber());
            return copy;
        }
        return null;
    }

    public String showMultiship(HttpServletRequest request, HttpServletResponse response, Model model) {
        Customer customer = CustomerState.getCustomer();
        Order cart = CartState.getCart();
        model.addAttribute("orderMultishipOptions", (Object)this.orderMultishipOptionService.getOrGenerateOrderMultishipOptions(cart));
        model.addAttribute("customerAddresses", (Object)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()));
        model.addAttribute("fulfillmentOptions", (Object)this.fulfillmentOptionService.readAllFulfillmentOptions());
        return this.getMultishipView();
    }

    public String saveMultiship(HttpServletRequest request, HttpServletResponse response, Model model, OrderMultishipOptionForm orderMultishipOptionForm, BindingResult result) throws PricingException, ServiceException {
        Order cart = CartState.getCart();
        this.orderMultishipOptionService.saveOrderMultishipOptions(cart, orderMultishipOptionForm.getOptions());
        cart = this.fulfillmentGroupService.matchFulfillmentGroupsToMultishipOptions(cart, true);
        ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).performAdditionalShippingAction();
        return this.getMultishipSuccessView();
    }

    public String showMultishipAddAddress(HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAttribute("states", (Object)this.stateService.findStates());
        model.addAttribute("countries", (Object)this.countryService.findCountries());
        model.addAttribute("countrySubdivisions", (Object)this.countrySubdivisionService.findSubdivisions());
        return this.getMultishipAddAddressView();
    }

    public String saveMultishipAddAddress(HttpServletRequest request, HttpServletResponse response, Model model, ShippingInfoForm addressForm, BindingResult result) throws ServiceException {
        this.multishipAddAddressFormValidator.validate(addressForm, (Errors)result);
        if (result.hasErrors()) {
            return this.showMultishipAddAddress(request, response, model);
        }
        CustomerAddress customerAddress = this.customerAddressService.create();
        customerAddress.setAddressName(addressForm.getAddressName());
        customerAddress.setAddress(addressForm.getAddress());
        customerAddress.setCustomer(CustomerState.getCustomer());
        this.customerAddressService.saveCustomerAddress(customerAddress);
        return this.getMultishipAddAddressSuccessView() + "?_=" + System.currentTimeMillis();
    }

    public String saveMultiShipInstruction(HttpServletRequest request, HttpServletResponse response, Model model, MultiShipInstructionForm instructionForm) throws ServiceException, PricingException {
        Order cart = CartState.getCart();
        FulfillmentGroup fulfillmentGroup = null;
        for (FulfillmentGroup tempFulfillmentGroup : cart.getFulfillmentGroups()) {
            if (!tempFulfillmentGroup.getId().equals(instructionForm.getFulfillmentGroupId())) continue;
            fulfillmentGroup = tempFulfillmentGroup;
        }
        fulfillmentGroup.setPersonalMessage(instructionForm.getPersonalMessage());
        fulfillmentGroup.setDeliveryInstruction(instructionForm.getDeliveryMessage());
        this.fulfillmentGroupService.save(fulfillmentGroup);
        return this.getCheckoutPageRedirect() + "?_=" + System.currentTimeMillis();
    }
}

